/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.remote;

import java.io.IOException;
import lejos.nxt.TachoMotorPort;
import lejos.nxt.remote.NXTCommand;
import lejos.nxt.remote.NXTProtocol;

public class RemoteMotorPort
implements NXTProtocol,
TachoMotorPort {
    private NXTCommand nxtCommand;
    private int id;

    public RemoteMotorPort(NXTCommand nxtCommand, int id) {
        this.nxtCommand = nxtCommand;
        this.id = id;
    }

    public void controlMotor(int power, int mode) {
        int lcpMode = 0;
        int lcpPower = power;
        int runState = 0;
        if (mode == 1) {
            lcpMode = 1;
            runState = 32;
        } else if (mode == 2) {
            lcpMode = 1;
            lcpPower = -lcpPower;
            runState = 32;
        } else if (mode == 3) {
            lcpPower = 0;
            lcpMode = 2;
            runState = 0;
        } else {
            lcpPower = 0;
            lcpMode = 0;
            runState = 0;
        }
        try {
            this.nxtCommand.setOutputState((byte)this.id, (byte)lcpPower, lcpMode, 0, 0, runState, 0);
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    public int getTachoCount() {
        try {
            return this.nxtCommand.getTachoCount(this.id);
        }
        catch (IOException ioe) {
            return 0;
        }
    }

    public void resetTachoCount() {
        try {
            this.nxtCommand.resetMotorPosition(this.id, false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setPWMMode(int mode) {
    }
}

