/*
 * Decompiled with CFR 0.152.
 */
package lejos.robotics;

import lejos.robotics.ElevationPlatform;
import lejos.robotics.SimplePlatform;
import lejos.robotics.TachoMotor;

public class ExtendedPlatform
extends SimplePlatform
implements ElevationPlatform {
    TachoMotor elevationMotor = null;
    boolean invertElev = false;
    float ratioElev = 1.0f;
    int maxElev;
    int minElev;

    public ExtendedPlatform(TachoMotor directionMotor, TachoMotor elevationMotor) {
        this(directionMotor, false, elevationMotor, false);
    }

    public ExtendedPlatform(TachoMotor directionMotor, boolean invertDir, TachoMotor elevationMotor, boolean invertElev) {
        this(directionMotor, invertDir, 1.0, elevationMotor, invertDir, 1.0);
    }

    public ExtendedPlatform(TachoMotor directionMotor, boolean invertDir, double ratioDir, TachoMotor elevationMotor, boolean invertElev, double ratioElev) {
        super(directionMotor, invertDir, ratioDir);
        this.elevationMotor = elevationMotor;
        this.invertElev = invertElev;
        this.ratioElev = (float)ratioElev;
    }

    public int getElevation() {
        if (this.invertElev) {
            return (int)((float)(-this.elevationMotor.getTachoCount()) * this.ratioElev);
        }
        return (int)((float)this.elevationMotor.getTachoCount() * this.ratioElev);
    }

    public int getMaximumElevation() {
        return this.maxElev;
    }

    public int getMinimumElevation() {
        return this.minElev;
    }

    public int getElevationSpeed() {
        return (int)((float)this.elevationMotor.getSpeed() / this.ratioElev);
    }

    public void scanUp() {
        this.setElevation(this.getMaximumElevation());
    }

    public void scanDown() {
        this.setElevation(this.getMinimumElevation());
    }

    public void setElevation(int angle) {
        if (this.invertElev) {
            angle = -angle;
        }
        this.elevationMotor.rotateTo((int)((float)angle * this.ratioElev));
    }

    public void setMaximumElevation(int maxAngle) {
        this.maxElev = maxAngle;
    }

    public void setMinimumElevation(int minAngle) {
        this.minElev = minAngle;
    }

    public void setElevationSpeed(int speed) {
        this.elevationMotor.setSpeed((int)((float)speed * this.ratioElev));
    }

    public void stopElevation() {
        this.elevationMotor.stop();
    }
}

