/*
 * Decompiled with CFR 0.152.
 */
package lejos.robotics;

public class Movement {
    protected float distanceTraveled;
    protected float angleTurned;
    protected MovementType movementType;
    protected float arcRadius = Float.POSITIVE_INFINITY;
    protected boolean isMoving;
    protected long timeStamp;

    public Movement(MovementType type, float distance, float angle, boolean isMoving) {
        this.movementType = type;
        this.distanceTraveled = distance;
        this.angleTurned = angle;
        this.isMoving = isMoving;
        if ((double)Math.abs(angle) > 0.5) {
            double turnRad = Math.toRadians(angle);
            this.arcRadius = (float)((double)distance / turnRad);
        }
        this.timeStamp = System.currentTimeMillis();
    }

    public float getDistanceTraveled() {
        return this.distanceTraveled;
    }

    public float getAngleTurned() {
        return this.angleTurned;
    }

    public MovementType getMovementType() {
        return this.movementType;
    }

    public float getArcRadius() {
        return this.arcRadius;
    }

    public boolean isMoving() {
        return this.isMoving;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MovementType {
        TRAVEL,
        ROTATE,
        ARC;

    }
}

