/*
 * Decompiled with CFR 0.152.
 */
package lejos.robotics;

import lejos.geom.Point;

public class Pose {
    protected Point _location;
    protected float _heading;

    public Pose() {
        this._location = new Point(0.0f, 0.0f);
        this._heading = 0.0f;
    }

    public Pose(float x, float y, float heading) {
        this._location = new Point(x, y);
        this._heading = heading;
    }

    public void rotateUpdate(float angle) {
        this._heading += angle;
        while (this._heading < 180.0f) {
            this._heading += 360.0f;
        }
        while (this._heading > 180.0f) {
            this._heading -= 360.0f;
        }
    }

    public void moveUpdate(float distance) {
        float x = distance * (float)Math.cos(Math.toRadians(this._heading));
        float y = distance * (float)Math.sin(Math.toRadians(this._heading));
        this.translate(x, y);
    }

    public void translate(float dx, float dy) {
        this._location.setLocation((float)this._location.getX() + dx, (float)this._location.getY() + dy);
    }

    public void arcUpdate(float distance, float turnAngle) {
        float dx = 0.0f;
        float dy = 0.0f;
        double heading = Math.toRadians(this._heading);
        if ((double)Math.abs(turnAngle) > 0.5) {
            float turn = (float)Math.toRadians(turnAngle);
            float radius = distance / turn;
            dy = radius * (float)(Math.cos(heading) - Math.cos(heading + (double)turn));
            dx = radius * (float)(Math.sin(heading + (double)turn) - Math.sin(heading));
        } else if ((double)Math.abs(distance) > 0.01) {
            dx = distance * (float)Math.cos(heading);
            dy = distance * (float)Math.sin(heading);
        }
        this.translate(dx, dy);
        this.rotateUpdate(turnAngle);
    }

    public float angleTo(Point destination) {
        Point d = this.delta(destination);
        return (float)Math.toDegrees(Math.atan2(d.getY(), d.getX()));
    }

    public float distanceTo(Point destination) {
        Point d = this.delta(destination);
        return (float)Math.sqrt(d.getX() * d.getX() + d.getY() * d.getY());
    }

    private Point delta(Point d) {
        return new Point((float)(d.getX() - this._location.getX()), (float)(d.getY() - this._location.getY()));
    }

    public float getHeading() {
        return this._heading;
    }

    public float getX() {
        return (float)this._location.getX();
    }

    public float getY() {
        return (float)this._location.getY();
    }

    public Point getLocation() {
        return this._location;
    }

    public void setLocation(Point p) {
        this._location = p;
    }

    public void setHeading(float heading) {
        this._heading = heading;
    }
}

