/*
 * Decompiled with CFR 0.152.
 */
package lejos.robotics;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import lejos.robotics.RangeReading;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeReadings
extends ArrayList<RangeReading> {
    private int numReadings;

    public RangeReadings(int numReadings) {
        super(numReadings);
        this.numReadings = numReadings;
        for (int i = 0; i < numReadings; ++i) {
            this.add(new RangeReading(0.0f, -1.0f));
        }
    }

    public float getRange(int i) {
        return ((RangeReading)this.get(i)).getRange();
    }

    public float getRange(float angle) {
        for (RangeReading r : this) {
            if (r.getAngle() != angle) continue;
            return r.getRange();
        }
        return -1.0f;
    }

    public float getAngle(int index) {
        return ((RangeReading)this.get(index)).getAngle();
    }

    public boolean incomplete() {
        for (RangeReading r : this) {
            if (!r.invalidReading()) continue;
            return true;
        }
        return false;
    }

    public int getNumReadings() {
        return this.numReadings;
    }

    public void setRange(int index, float angle, float range) {
        this.set(index, new RangeReading(angle, range));
    }

    public void dumpReadings(DataOutputStream dos) throws IOException {
        for (RangeReading r : this) {
            dos.writeFloat(r.getAngle());
            dos.writeFloat(r.getRange());
        }
        dos.flush();
    }

    public void loadReadings(DataInputStream dis) throws IOException {
        for (int i = 0; i < this.getNumReadings(); ++i) {
            this.setRange(i, dis.readFloat(), dis.readFloat());
        }
    }

    public void printReadings() {
        int index = 0;
        for (RangeReading r : this) {
            System.out.println("Range " + index + " = " + (r.invalidReading() ? "Invalid" : Float.valueOf(r.getRange())));
            ++index;
        }
    }
}

