/*
 * Decompiled with CFR 0.152.
 */
package lejos.robotics.localization;

import lejos.robotics.MoveListener;
import lejos.robotics.Movement;
import lejos.robotics.MovementProvider;
import lejos.robotics.Pose;
import lejos.robotics.RangeReadings;
import lejos.robotics.RangeScanner;
import lejos.robotics.localization.MCLParticleSet;
import lejos.robotics.localization.PoseProvider;
import lejos.robotics.mapping.RangeMap;

public class MCLPoseProvider
implements PoseProvider,
MoveListener {
    private MCLParticleSet particles;
    private RangeScanner scanner;
    private RangeMap map;
    private boolean readingsRequired = true;

    public MCLPoseProvider(MovementProvider mp, RangeScanner scanner, RangeMap map, int numParticles, int border) {
        this.particles = new MCLParticleSet(map, numParticles, border);
        this.scanner = scanner;
        this.map = map;
        mp.addMoveListener(this);
    }

    public MCLParticleSet getParticles() {
        return this.particles;
    }

    public void movementStarted(Movement event, MovementProvider mp) {
    }

    public void movementStopped(Movement event, MovementProvider mp) {
        this.readingsRequired = true;
        this.particles.applyMove(event);
    }

    public Pose getPose() {
        if (this.readingsRequired) {
            RangeReadings rr = this.scanner.getRangeValues();
            this.readingsRequired = false;
            if (!rr.incomplete()) {
                this.particles.calculateWeights(rr, this.map);
                this.particles.resample();
            }
        }
        return this.particles.getEstimatedPose();
    }
}

