/*
 * Decompiled with CFR 0.152.
 */
package lejos.robotics.proposal;

import lejos.geom.Point;
import lejos.robotics.Pose;
import lejos.robotics.localization.PoseProvider;
import lejos.robotics.proposal.ArcPilot;
import lejos.robotics.proposal.PoseController;
import lejos.robotics.proposal.RotatePilot;

public class ArcPoseController
implements PoseController {
    private ArcPilot pilot;
    private PoseProvider poseProvider;

    public ArcPoseController(ArcPilot pilot, PoseProvider poseProvider) {
        this.pilot = pilot;
        this.poseProvider = poseProvider;
    }

    public ArcPilot getPilot() {
        return this.pilot;
    }

    public PoseProvider getPoseProvider() {
        return this.poseProvider;
    }

    public void setPoseProvider(PoseProvider replacement) {
        this.poseProvider = replacement;
    }

    public Pose goTo(Point destination) {
        Pose pose = this.poseProvider.getPose();
        if (this.pilot instanceof RotatePilot) {
            float turnAngle;
            for (turnAngle = pose.angleTo(destination) - pose.getHeading(); turnAngle < -180.0f; turnAngle += 360.0f) {
            }
            while (turnAngle > 180.0f) {
                turnAngle -= 360.0f;
            }
            ((RotatePilot)((Object)this.pilot)).rotate(turnAngle);
            this.pilot.travel(pose.distanceTo(destination));
        }
        return this.poseProvider.getPose();
    }

    public Pose goTo(float x, float y) {
        return this.goTo(new Point(x, y));
    }
}

