/*
 * Decompiled with CFR 0.152.
 */
package lejos.robotics.proposal;

import lejos.geom.Point;
import lejos.robotics.Pose;

public class WayPoint
extends Point {
    protected float heading = 0.0f;
    protected boolean headingRequired;
    protected float maxPositionError = -1.0f;
    protected float maxHeadingError = -1.0f;

    public WayPoint(float x, float y) {
        super(x, y);
        this.headingRequired = false;
    }

    public WayPoint(Point p) {
        super((float)p.getX(), (float)p.getY());
        this.headingRequired = true;
    }

    public WayPoint(Pose p) {
        super(p.getX(), p.getY());
        this.headingRequired = true;
        this.heading = p.getHeading();
    }

    public float getHeading() {
        return this.heading;
    }

    public float getMaxPositionError() {
        return this.maxPositionError;
    }

    public void setMaxPositionError(float distance) {
        this.maxPositionError = distance;
    }

    public float getMaxHeadingError() {
        return this.maxHeadingError;
    }

    public void setMaxHeadingError(float distance) {
        this.maxHeadingError = distance;
    }

    public Pose getPose() {
        return new Pose(this.x, this.y, this.heading);
    }

    public boolean checkValidity(Pose p) {
        if (this.maxPositionError >= 0.0f && p.distanceTo(this) > this.maxPositionError) {
            return false;
        }
        return !this.headingRequired || !(this.maxHeadingError >= 0.0f) || !(Math.abs(p.getHeading() - this.heading) > this.maxPositionError);
    }
}

