/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DataOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int written;

    public DataOutputStream(OutputStream out) {
        super(out);
    }

    private void incCount(int value) {
        int temp = this.written + value;
        if (temp < 0) {
            temp = Integer.MAX_VALUE;
        }
        this.written = temp;
    }

    public final int size() {
        return this.written;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.incCount(len);
    }

    public void write(int b) throws IOException {
        this.out.write(b);
        this.incCount(1);
    }

    public final void writeBoolean(boolean v) throws IOException {
        this.out.write(v ? 1 : 0);
        this.incCount(1);
    }

    public final void writeByte(int v) throws IOException {
        this.out.write(v);
        this.incCount(1);
    }

    public final void writeBytes(String s) throws IOException {
        int len = s.length();
        OutputStream o = this.out;
        for (int i = 0; i < len; ++i) {
            o.write(s.charAt(i));
        }
        this.incCount(len);
    }

    public final void writeChar(int v) throws IOException {
        OutputStream o = this.out;
        o.write(v >>> 8);
        o.write(v);
        this.incCount(2);
    }

    public final void writeChars(String s) throws IOException {
        int len = s.length();
        OutputStream o = this.out;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            o.write(c >>> 8);
            o.write(c);
        }
        this.incCount(len << 1);
    }

    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public final void writeInt(int v) throws IOException {
        OutputStream o = this.out;
        o.write(v >>> 24);
        o.write(v >>> 16);
        o.write(v >>> 8);
        o.write(v);
        this.incCount(4);
    }

    public final void writeLong(long v) throws IOException {
        OutputStream o = this.out;
        int tmp = (int)(v >>> 32);
        o.write(tmp >>> 24);
        o.write(tmp >>> 16);
        o.write(tmp >>> 8);
        o.write(tmp);
        tmp = (int)v;
        o.write(tmp >>> 24);
        o.write(tmp >>> 16);
        o.write(tmp >>> 8);
        o.write(tmp);
        this.incCount(8);
    }

    public final void writeShort(int v) throws IOException {
        OutputStream o = this.out;
        o.write(v >>> 8);
        o.write(v);
        this.incCount(2);
    }

    public final void writeUTF(String s) throws IOException {
        throw new UnsupportedOperationException("not yet implemented");
    }
}

