/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;

public abstract class Writer {
    private static final int STRING_BUF_SIZE = 32;

    protected Writer() {
    }

    public Writer append(char c) throws IOException {
        this.write(new char[]{c}, 0, 1);
        return this;
    }

    public Writer append(CharSequence str) throws IOException {
        return this.append(str, 0, str.length());
    }

    public Writer append(CharSequence str, int start, int end) throws IOException {
        int buflen;
        char[] buffer = new char[32];
        for (int len = end - start; len > 0; len -= buflen) {
            buflen = len < 32 ? len : 32;
            for (int i = 0; i < buflen; ++i) {
                buffer[i] = str.charAt(start + i);
            }
            this.write(buffer, 0, buflen);
            start += buflen;
        }
        return this;
    }

    public abstract void close() throws IOException;

    public abstract void flush() throws IOException;

    public void write(char[] c) throws IOException {
        this.write(c, 0, c.length);
    }

    public abstract void write(char[] var1, int var2, int var3) throws IOException;

    public void write(int c) throws IOException {
        this.write(new char[]{(char)c}, 0, 1);
    }

    public void write(String str) throws IOException {
        this.write(str, 0, str.length());
    }

    public void write(String str, int off, int len) throws IOException {
        char[] buffer = new char[32];
        while (len > 0) {
            int buflen = len < 32 ? len : 32;
            int end = off + buflen;
            str.getChars(off, end, buffer, 0);
            this.write(buffer, 0, buflen);
            off = end;
            len -= buflen;
        }
    }
}

