/*
 * Decompiled with CFR 0.152.
 */
package lejos.addon.gps;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import lejos.addon.gps.NMEASentence;
import lejos.addon.gps.Satellite;

public class GSVSentence
extends NMEASentence {
    private int satellitesInView = 0;
    private Satellite[] ns;
    private int currentSentence;
    private int currentSatellite;
    private int totalSentences;
    private String[] sentences;
    public static final String HEADER = "$GPGSV";

    public String getHeader() {
        return HEADER;
    }

    public int getSatellitesInView() {
        this.checkRefresh();
        return this.satellitesInView;
    }

    public Satellite getSatellite(int index) {
        this.checkRefresh();
        return this.ns[index];
    }

    protected void setSentence(String sentence, int sentenceNumber, int total) {
        if (sentenceNumber == 1) {
            this.sentences = new String[total];
        }
        this.sentences[sentenceNumber - 1] = sentence;
    }

    protected void parse(String sentence) {
        try {
            for (int i = 0; i < this.sentences.length; ++i) {
                this.st = new StringTokenizer(this.sentences[i], ",");
                this.st.nextToken();
                this.totalSentences = Integer.parseInt(this.st.nextToken());
                this.currentSentence = Integer.parseInt(this.st.nextToken());
                this.satellitesInView = Integer.parseInt(this.st.nextToken());
                if (this.currentSentence == 1) {
                    this.ns = new Satellite[this.satellitesInView];
                    for (int j = 0; j < this.ns.length; ++j) {
                        this.ns[j] = new Satellite();
                    }
                    this.currentSatellite = 0;
                }
                while (this.currentSatellite < this.currentSentence * 4) {
                    int PRN = Integer.parseInt(this.st.nextToken());
                    int elevation = Integer.parseInt(this.st.nextToken());
                    int azimuth = Integer.parseInt(this.st.nextToken());
                    int SNR = Integer.parseInt(this.st.nextToken());
                    this.ns[this.currentSatellite].setPRN(PRN);
                    this.ns[this.currentSatellite].setElevation(elevation);
                    this.ns[this.currentSatellite].setAzimuth(azimuth);
                    this.ns[this.currentSatellite].setSignalNoiseRatio(SNR);
                    ++this.currentSatellite;
                }
            }
        }
        catch (NoSuchElementException e) {
            System.err.println("GSVSentence Exception");
        }
        catch (NumberFormatException e) {
            System.err.println("GSVSentence NFException");
        }
    }
}

