/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt;

import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VM {
    private static final int ABSOLUTE = 0;
    private static final int THREADS = 1;
    private static final int HEAP = 2;
    private static final int IMAGE = 3;
    private static final int STATICS = 4;
    private static final int MEM = 5;
    private static final int OBJ_HDR_SZ = 4;
    private static final int OBJ_FLAGS = 1;
    private static final int OBJ_LEN_MASK = 63;
    private static final int OBJ_LEN_OBJECT = 63;
    private static final int OBJ_LEN_BIGARRAY = 62;
    private static final int OBJ_CLASS = 0;
    private static final int OBJ_BIGARRAY_LEN = 4;
    public static final int VM_OBJECT = 0;
    public static final int VM_CLASS = 2;
    public static final int VM_BOOLEAN = 4;
    public static final int VM_CHAR = 5;
    public static final int VM_FLOAT = 6;
    public static final int VM_DOUBLE = 7;
    public static final int VM_BYTE = 8;
    public static final int VM_SHORT = 9;
    public static final int VM_INT = 10;
    public static final int VM_LONG = 11;
    public static final int VM_VOID = 12;
    public static final int VM_OBJECTARRAY = 13;
    private static final int IMAGE_BASE = VM.memPeekInt(5, 12);
    private static final int IMAGE_HDR_LEN = 20;
    private static final int LAST_CLASS_OFFSET = 17;
    private static final int LAST_CLASS = VM.memPeekByte(3, 17);
    private int METHOD_BASE;
    private static final int METHOD_OFFSET = 4;
    private static VM theVM;
    private static final int CLASS_OBJ_HDR = 2;
    private static final int TABLE_ALIGNMENT = 4;
    private static final int CLASS_ALIGNMENT = 4;
    private static final int METHOD_ALIGNMENT = 2;
    private static final int EXCEPTION_ALIGNMENT = 2;
    private static final int FIELD_ALIGNMENT = 1;
    private static final int STATIC_FIELD_ALIGNMENT = 2;
    private static final int CONSTANT_ALIGNMENT = 2;
    private final VMImage image = new VMImage(IMAGE_BASE);
    private static final int FIELD_LEN = 2;
    private static final int CONSTANT_LEN = 4;
    private static final int EXCEPTION_LEN = 7;
    private static final int METHOD_LEN = 11;
    private static final int CLASS_LEN = 10;
    private static final int STACKFRAME_LEN = 20;
    private static final int THREAD_LEN = 31;
    public static final int VM_TYPECHECKS = 1;
    public static final int VM_ASSERT = 2;

    private VM() {
        this.METHOD_BASE = VM.memPeekShort(3, 24) + IMAGE_BASE;
    }

    public static VM getVM() {
        if (theVM == null) {
            theVM = new VM();
        }
        return theVM;
    }

    private static native int memPeek(int var0, int var1, int var2);

    private static native void memCopy(Object var0, int var1, int var2, int var3, int var4);

    private static native int getDataAddress(Object var0);

    private static native int getObjectAddress(Object var0);

    private static native Object memGetReference(int var0, int var1);

    private static int memPeekByte(int base, int offset) {
        return VM.memPeek(base, offset, 8) & 0xFF;
    }

    private static int memPeekShort(int base, int offset) {
        return VM.memPeek(base, offset, 9) & 0xFFFF;
    }

    private static int memPeekInt(int base, int offset) {
        return VM.memPeek(base, offset, 10);
    }

    public VMImage getImage() {
        return this.image;
    }

    private static int getClassAddress(int clsNo) {
        return IMAGE_BASE + 20 + (clsNo & 0xFF) * 12;
    }

    private int getClassNo(Object obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        int addr = VM.getObjectAddress(obj);
        int cls = VM.memPeekByte(0, addr + 0);
        return cls;
    }

    public static int getClassNumber(Class<?> cls) {
        int addr = VM.getObjectAddress(cls);
        return (addr - IMAGE_BASE - 20) / 12;
    }

    private static native boolean isAssignable(int var0, int var1);

    public static boolean isAssignable(Class<?> src, Class<?> dst) {
        if (src == null || dst == null) {
            throw new NullPointerException();
        }
        int srcNo = VM.getClassNumber(src);
        int dstNo = VM.getClassNumber(dst);
        return VM.isAssignable(srcNo, dstNo);
    }

    public Class<?> getClass(Object obj) {
        return (Class)VM.memGetReference(0, VM.getClassAddress(this.getClassNo(obj)));
    }

    public VMClass getVMClass(Object obj) {
        return new VMClass(VM.getClassAddress(this.getClassNo(obj)));
    }

    public static Class<?> getClass(int clsNo) {
        if (clsNo > LAST_CLASS) {
            return null;
        }
        return (Class)VM.memGetReference(0, VM.getClassAddress(clsNo));
    }

    public final VMClass getVMClass(Class<?> cls) {
        return new VMClass(VM.getObjectAddress(cls));
    }

    public final VMClass getVMClass(int clsNo) {
        if (clsNo > LAST_CLASS) {
            return null;
        }
        return new VMClass(VM.getClassAddress(clsNo));
    }

    public final VMMethod getMethod(int methodNo) {
        return new VMMethod(this.METHOD_BASE + methodNo * 12);
    }

    public final boolean isArray(Object obj) {
        if (obj == null) {
            return false;
        }
        return (VM.memPeekByte(0, VM.getObjectAddress(obj) + 1) & 0x3F) != 63;
    }

    public final VMFields getFields(Object obj) {
        return new VMFields(obj);
    }

    public final VMElements getElements(Object obj) {
        return new VMElements(obj);
    }

    public final VMThreads getVMThreads() {
        return new VMThreads();
    }

    public final VMThread getVMThread(Thread thread) {
        return new VMThread(VM.getDataAddress(thread));
    }

    public static final native void suspendThread(Object var0);

    public static final native void resumeThread(Object var0);

    public static final native void executeProgram(int var0);

    public static final native void setVMOptions(int var0);

    public static final native int getVMOptions();

    public static void enableRunTimeTypeChecks(boolean on) {
        int cur = VM.getVMOptions();
        cur = on ? (cur |= 1) : (cur &= 0xFFFFFFFE);
        VM.setVMOptions(cur);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class VMThreads
    implements Iterable<VMThread> {
        @Override
        public Iterator<VMThread> iterator() {
            return new VMThreadIterator();
        }

        private VMThreads() {
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class VMThreadIterator
        implements Iterator<VMThread> {
            private int nextPriority = 9;
            private int first = 0;
            private int nextThread = 0;

            private void findNext() {
                if (this.nextThread != 0) {
                    this.nextThread = VM.memPeekInt(0, this.nextThread + 4);
                }
                if (this.nextThread == this.first) {
                    this.first = 0;
                    while (this.nextPriority >= 0 && this.first == 0) {
                        this.first = VM.memPeekInt(1, this.nextPriority * 4);
                        --this.nextPriority;
                    }
                    this.nextThread = this.first;
                }
            }

            @Override
            public boolean hasNext() {
                return this.nextThread != 0;
            }

            @Override
            public VMThread next() {
                VMThread ret = new VMThread(this.nextThread + 4);
                this.findNext();
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported.");
            }

            VMThreadIterator() {
                this.findNext();
            }
        }
    }

    public final class VMThread
    extends VMClone {
        public Thread nextThread;
        public Object waitingOn;
        public int sync;
        public int sleepUntil;
        public Object stackFrameArray;
        public Object stackArray;
        public byte stackFrameArraySize;
        public byte monitorCount;
        public byte threadId;
        public byte state;
        public byte priority;
        public byte interrupted;
        public byte daemon;
        private final Thread thread;

        private VMThread(int addr) {
            super(addr, 31);
            this.thread = (Thread)VM.memGetReference(0, addr - 4);
        }

        public Thread getJavaThread() {
            return this.thread;
        }

        public VMStackFrames getStackFrames() {
            return new VMStackFrames(this.stackFrameArray, this.stackFrameArraySize);
        }

        public VMStackFrames getStackFrames(int frameCnt) {
            return new VMStackFrames(this.stackFrameArray, frameCnt);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class VMStackFrames
    extends VMItems<VMStackFrame> {
        private final int base;
        private final int size;

        private VMStackFrames(Object stackFrame, int size) {
            super(size);
            this.base = VM.getDataAddress(stackFrame);
            this.size = size;
        }

        @Override
        public VMStackFrame get(int item) {
            int offset = this.base + (this.size - item) * 20;
            return new VMStackFrame(offset);
        }
    }

    public final class VMStackFrame
    extends VMClone {
        public int methodRecord;
        public Object monitor;
        public int localsBase;
        public int pc;
        public int stackTop;

        private VMStackFrame(int addr) {
            super(addr, 20);
        }

        public VMMethod getVMMethod() {
            return new VMMethod(this.methodRecord);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class VMElements
    extends VMItems<VMValue> {
        private final int arrayBase;
        private final int typ;
        private final Object obj;

        VMElements(Object obj) {
            super(0);
            if (obj == null) {
                throw new NullPointerException();
            }
            int addr = VM.getObjectAddress(obj);
            int len = VM.memPeekByte(0, addr + 1) & 0x3F;
            if (len == 63) {
                this.typ = -1;
                this.arrayBase = 0;
            } else {
                int cls = VM.memPeekByte(0, addr + 0);
                this.cnt = this.cnt >= 62 ? VM.memPeekByte(0, addr + 4) : len;
                this.arrayBase = VM.getDataAddress(obj);
                this.typ = cls >= 17 && cls <= 24 ? cls - 13 : 0;
            }
            this.obj = obj;
        }

        @Override
        public VMValue get(int item) {
            if (item >= this.cnt) {
                throw new ArrayIndexOutOfBoundsException();
            }
            int offset = this.arrayBase + item * VMValue.lengths[this.typ];
            return new VMValue(this.typ, offset);
        }

        public int length() {
            return this.cnt;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class VMFields
    extends VMItems<VMValue> {
        private final int[] fieldOffsets;
        private final byte[] fieldTypes;
        private final Object obj;

        private VMFields(Object obj) {
            super(0);
            VMClass cls = VM.this.getVMClass(obj);
            if (VM.this.isArray(obj)) {
                this.fieldOffsets = new int[0];
                this.fieldTypes = new byte[0];
            } else {
                this.cnt = cls.CIACnt2 & 0xFF;
                while (cls.parentClass != 0) {
                    cls = VM.this.getVMClass(cls.parentClass);
                    this.cnt += cls.CIACnt2 & 0xFF;
                }
                this.fieldOffsets = new int[this.cnt];
                this.fieldTypes = new byte[this.cnt];
                cls = VM.this.getVMClass(obj);
                int fieldBase = VM.getObjectAddress(obj);
                int offset = fieldBase + cls.size;
                int item = this.cnt - 1;
                while (true) {
                    int fieldTable = cls.CIAData2 + IMAGE_BASE;
                    for (int i = (cls.CIACnt2 & 0xFF) - 1; i >= 0; --i) {
                        this.fieldTypes[item] = (byte)VM.memPeekByte(0, fieldTable + i);
                        this.fieldOffsets[item--] = offset -= VMValue.lengths[this.fieldTypes[item]];
                    }
                    if (cls.parentClass == 0) break;
                    cls = VM.this.getVMClass(cls.parentClass);
                }
            }
            this.obj = obj;
        }

        @Override
        public VMValue get(int item) {
            if (item >= this.cnt) {
                throw new NoSuchFieldError();
            }
            return new VMValue(this.fieldTypes[item], this.fieldOffsets[item]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class VMClasses
    extends VMItems<VMClass> {
        private VMClasses(int cnt) {
            super(cnt);
        }

        @Override
        public VMClass get(int item) {
            if (item >= this.cnt) {
                throw new NoClassDefFoundError();
            }
            return new VMClass(VM.getClassAddress(item));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class VMClass
    extends VMClone {
        public short size;
        public short CIAData1;
        public short CIAData2;
        public byte CIACnt1;
        public byte CIACnt2;
        public byte parentClass;
        public byte flags;
        public static final byte C_ARRAY = 2;
        public static final byte C_HASCLINIT = 4;
        public static final byte C_INTERFACE = 8;
        public static final byte C_NOREFS = 16;
        public static final byte C_PRIMITIVE = 32;
        private int clsNo;

        private VMClass(int addr) {
            super(addr + 2, 10);
            this.clsNo = (addr - IMAGE_BASE - 20) / 12;
        }

        public VMMethods getMethods() {
            if ((this.flags & 0xA) != 0) {
                return new VMMethods(0, 0);
            }
            return new VMMethods(this.CIAData1 + IMAGE_BASE, this.CIACnt1 & 0xFF);
        }

        public int getClassNo() {
            return this.clsNo;
        }

        public Class<?> getJavaClass() {
            return (Class)VM.memGetReference(0, VM.getClassAddress(this.clsNo));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class VMMethods
    extends VMItems<VMMethod> {
        private final int baseAddr;

        private VMMethods(int baseAddr, int cnt) {
            super(cnt);
            this.baseAddr = baseAddr;
        }

        @Override
        public VMMethod get(int item) {
            return new VMMethod(this.baseAddr + item * 12);
        }
    }

    public final class VMMethod
    extends VMClone {
        public short signature;
        public short exceptionTable;
        public short codeOffset;
        public byte numLocals;
        public byte maxOperands;
        public byte numParameters;
        public byte numExceptionHandlers;
        public byte mflags;
        public static final byte M_NATIVE = 1;
        public static final byte M_SYNCHRONIZED = 2;
        public static final byte M_STATIC = 4;

        private VMMethod(int addr) {
            super(addr, 11);
        }

        public VMExceptions getVMExceptions() {
            return new VMExceptions(this.exceptionTable + IMAGE_BASE, this.numExceptionHandlers);
        }

        public int getMethodNumber() {
            return (this.address - VM.this.METHOD_BASE) / 12;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class VMExceptions
    extends VMItems<VMException> {
        private final int baseAddr;

        private VMExceptions(int baseAddr, int cnt) {
            super(cnt);
            this.baseAddr = baseAddr;
        }

        @Override
        public VMException get(int item) {
            return new VMException(this.baseAddr + item * 8);
        }
    }

    public static final class VMException
    extends VMClone {
        public short start;
        public short end;
        public short handler;
        public byte classIndex;

        private VMException(int addr) {
            super(addr, 7);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class VMConstants
    extends VMItems<VMValue> {
        private final int baseAddr;

        @Override
        public VMValue get(int item) {
            if (item >= this.cnt) {
                throw new NoSuchFieldError();
            }
            int addr = this.baseAddr + item * 4;
            int offset = VM.memPeekShort(0, addr) + IMAGE_BASE;
            int typ = VM.memPeekByte(0, addr + 2);
            int len = VM.memPeekByte(0, addr + 3);
            if (typ == 0) {
                char[] chars = new char[len];
                for (int i = 0; i < len; ++i) {
                    chars[i] = (char)VM.memPeekByte(0, offset + i);
                }
                return new VMValue(new String(chars));
            }
            len = VMValue.lengths[typ];
            return new VMValue(typ, offset);
        }

        private VMConstants(int base, int cnt) {
            super(cnt);
            this.baseAddr = base;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class VMStaticFields
    extends VMItems<VMValue> {
        private final int baseAddr;
        private final int dataAddr;

        @Override
        public VMValue get(int item) {
            if (item >= this.cnt) {
                throw new NoSuchFieldError();
            }
            int addr = this.baseAddr + item * 2;
            int rec = VM.memPeekShort(0, addr);
            int typ = rec >> 12 & 0xF;
            int offset = rec & 0xFFF;
            return new VMValue(typ, this.dataAddr + offset);
        }

        private VMStaticFields(int base, int cnt) {
            super(cnt);
            this.baseAddr = base;
            this.dataAddr = VM.memPeekInt(5, 16);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class VMItems<E>
    implements Iterable<E> {
        int cnt;

        @Override
        public Iterator<E> iterator() {
            return new VMItemsIterator();
        }

        public abstract E get(int var1);

        private VMItems(int cnt) {
            this.cnt = cnt;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class VMItemsIterator
        implements Iterator<E> {
            int next = 0;

            private VMItemsIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.next < VMItems.this.cnt;
            }

            @Override
            public E next() {
                return VMItems.this.get(this.next++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        }
    }

    public final class VMImage
    extends VMClone {
        public short magicNumber;
        public short constantTableOffset;
        public short constantValuesOffset;
        public short numConstants;
        public short staticFieldsOffset;
        public short staticStateLength;
        public short numStaticFields;
        public short entryClassesOffset;
        public byte numEntryClasses;
        public byte lastClass;
        public short runtimeOptions;

        private VMImage(int addr) {
            super(addr, 20);
        }

        public VMClasses getVMClasses() {
            return new VMClasses(this.lastClass + 1);
        }

        public VMConstants getVMConstants() {
            return new VMConstants(this.constantTableOffset + IMAGE_BASE, this.numConstants);
        }

        public VMStaticFields getVMStaticFields() {
            return new VMStaticFields(this.staticFieldsOffset + IMAGE_BASE, this.numStaticFields);
        }

        public int getImageBase() {
            return IMAGE_BASE;
        }
    }

    public static class VMValue {
        public final int type;
        public final Object value;
        private static final int[] lengths = new int[]{4, 0, 1, 0, 1, 2, 4, 8, 1, 2, 4, 8};

        private VMValue(int typ, int addr) {
            this.type = typ;
            switch (typ) {
                case 0: {
                    this.value = VM.memGetReference(0, VM.memPeekInt(0, addr));
                    break;
                }
                case 10: {
                    this.value = new Integer(VM.memPeekInt(0, addr));
                    break;
                }
                case 8: {
                    this.value = new Byte((byte)VM.memPeekByte(0, addr));
                    break;
                }
                case 5: {
                    this.value = new Character((char)VM.memPeekShort(0, addr));
                    break;
                }
                case 9: {
                    this.value = new Short((short)VM.memPeekShort(0, addr));
                    break;
                }
                case 11: {
                    this.value = new Long((long)VM.memPeekInt(0, addr) << 32 | (long)VM.memPeekInt(0, addr + 4));
                    break;
                }
                case 6: {
                    this.value = new Float(Float.intBitsToFloat(VM.memPeekInt(0, addr)));
                    break;
                }
                case 7: {
                    this.value = new Double(Double.longBitsToDouble((long)VM.memPeekInt(0, addr) << 32 | (long)VM.memPeekInt(0, addr + 4)));
                    break;
                }
                case 4: {
                    this.value = new Boolean(VM.memPeekByte(0, addr) != 0);
                    break;
                }
                case 2: {
                    this.value = VM.getVM().getVMClass(VM.memPeekByte(0, addr));
                    break;
                }
                default: {
                    throw new NoSuchFieldError();
                }
            }
        }

        private VMValue(Object obj) {
            this.type = 0;
            this.value = obj;
        }
    }

    public static class VMClone {
        private static final int CLONE_OFFSET = 8;
        private final int length;
        final int address;

        public void update() {
            VM.memCopy(this, 8, 0, this.address, this.length);
        }

        private VMClone(int addr, int len) {
            this.address = addr;
            this.length = len;
            this.update();
        }
    }
}

