/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.addon;

import lejos.nxt.I2CPort;
import lejos.nxt.I2CSensor;

public class OpticalDistanceSensor
extends I2CSensor {
    private byte[] buf = new byte[2];
    private static final int COMMAND = 65;
    private static final int DIST_DATA_LSB = 66;
    private static final int DIST_DATA_MSB = 67;
    private static final int VOLT_DATA_LSB = 68;
    private static final int VOLT_DATA_MSB = 69;
    private static final int SENSOR_MOD_TYPE = 80;
    private static final int CURVE = 81;
    private static final int DIST_MIN_DATA_LSB = 82;
    private static final int DIST_MIN_DATA_MSB = 83;
    private static final int DIST_MAX_DATA_LSB = 84;
    private static final int DIST_MAX_DATA_MSB = 85;
    private static final int VOLT_DATA_POINT_LSB = 82;
    private static final int VOLT_DATA_POINT_MSB = 83;
    private static final int DIST_DATA_POINT_LSB = 84;
    private static final int DIST_DATA_POINT_MSB = 85;
    public static final byte GP2D12 = 49;
    public static final byte GP2D120 = 50;
    public static final byte GP2YA21 = 51;
    public static final byte GP2YA02 = 52;
    public static final byte CUSTOM = 53;
    private static final byte DE_ENERGIZED = 68;
    private static final byte ENERGIZED = 69;
    private static final byte ARPA_ON = 78;
    private static final byte ARPA_OFF = 79;

    public OpticalDistanceSensor(I2CPort port) {
        super(port);
        this.powerOn();
    }

    public void setSensorModule(byte module) {
        this.sendData(65, module);
    }

    public int getDistance() {
        return this.getDistLSB();
    }

    public void powerOn() {
        this.sendData(65, (byte)69);
    }

    public void powerOff() {
        this.sendData(65, (byte)68);
    }

    public void setAPDAOn() {
        this.sendData(65, (byte)78);
    }

    public void setAPDAOff() {
        this.sendData(65, (byte)79);
    }

    public int getDistLSB() {
        return this.readDISTNX(66, 2);
    }

    public int getDistMSB() {
        return this.readDISTNX(67, 2);
    }

    public int getVoltLSB() {
        return this.readDISTNX(68, 2);
    }

    public int getVoltMSB() {
        return this.readDISTNX(69, 2);
    }

    public int getSensorModule() {
        return this.readDISTNX(80, 1);
    }

    public int getCurveCount() {
        return this.readDISTNX(81, 1);
    }

    public void setCurveCount(int value) {
        this.sendData(81, (byte)value);
    }

    public int getDistMinLSB() {
        return this.readDISTNX(82, 2);
    }

    public void setDistMinLSB(int value) {
        this.writeDISTNX(82, (byte)value);
    }

    public int getDistMinMSB() {
        return this.readDISTNX(83, 2);
    }

    public void setDistMinMSB(int value) {
        this.writeDISTNX(83, (byte)value);
    }

    public int getDistMaxLSB() {
        return this.readDISTNX(84, 2);
    }

    public void setDistMaxLSB(int value) {
        this.writeDISTNX(84, (byte)value);
    }

    public int getDistMaxMSB() {
        return this.readDISTNX(85, 2);
    }

    public void setDistMaxMSB(int value) {
        this.writeDISTNX(85, (byte)value);
    }

    public int getVoltPointLSB(int index) {
        if (index == 0) {
            index = 1;
        }
        index = 82 + 4 * index;
        return this.readDISTNX(index, 2);
    }

    public void setVoltPointLSB(int index, int value) {
        if (index == 0) {
            index = 1;
        }
        index = 82 + 4 * index;
        this.sendData(index, (byte)value);
    }

    public int getVoltPointMSB(int index) {
        if (index == 0) {
            index = 1;
        }
        index = 83 + 4 * index;
        return this.readDISTNX(index, 2);
    }

    public void setVoltPointMSB(int index, int value) {
        if (index == 0) {
            index = 1;
        }
        index = 83 + 4 * index;
        this.writeDISTNX(index, value);
    }

    public int getDistPointLSB(int index) {
        if (index == 0) {
            index = 1;
        }
        index = 84 + 4 * index;
        return this.readDISTNX(index, 2);
    }

    public void setDistPointLSB(int index, int value) {
        if (index == 0) {
            index = 1;
        }
        index = 84 + 4 * index;
        this.writeDISTNX(index, value);
    }

    public int getDistPointMSB(int index) {
        if (index == 0) {
            index = 1;
        }
        index = 85 + 4 * index;
        return this.readDISTNX(index, 2);
    }

    public void setDistPointMSB(int index, int value) {
        if (index == 0) {
            index = 1;
        }
        index = 85 + 4 * index;
        this.writeDISTNX(index, value);
    }

    private int readDISTNX(int register, int bytes) {
        this.getData(register, this.buf, bytes);
        if (bytes == 1) {
            return this.buf[0] & 0xFF;
        }
        int buf0 = this.buf[0] & 0xFF;
        int buf1 = this.buf[1] & 0xFF;
        return buf1 * 256 + buf0;
    }

    private void writeDISTNX(int register, int value) {
        int buf0 = value % 256;
        int buf1 = value / 256;
        this.buf[0] = (byte)buf0;
        this.buf[1] = (byte)buf1;
        this.sendData(register, this.buf, 2);
    }
}

