package etrobo.sample2010;

import lejos.nxt.*;
import java.io.*;
import lejos.util.*;

/* Tachometer, Line, LineMap, Landmark */

public class LineTracer implements Runnable
{
	/* 下記のパラメータはセンサ個体/環境に合わせてチューニングする必要があります */
//	private static final int WHITE = 500; /* 白色の光センサ値 */
//	private static final int BLACK = 700; /* 黒色の光センサ値 */

	private LightSensor light = new LightSensor(SensorPort.S3);
	private UltrasonicSensor sonar = new UltrasonicSensor(SensorPort.S2);
	private float forward; /* 前後進命令: -100(後進)～0(停止)～100(前進) */
	private float turn; /* 旋回命令: -100(左旋回)～100(右旋回) */
	private boolean pause; /* 一時停止 */
	private boolean available;

	/* 下記はまいまい式で使用する変数 */
	private final float THRESHOLD = 0.7F; /* ラインエッジ閾値								*/
	static double brightness;	/* コース明度			*/
	static int lightDowned;		/* 消灯時の光センサー値	*/
	static int lightUpped;		/* 点灯時の光センサー値	*/

	/* PID制御パラメタ */
	private final double KP = 40;
	private final double KI = 0;
	private final double KD = 200;
	private double deviation;
	private double preDeviation;
	private double prePreDeviation;

	/* 経過時間取得用 */
	private Stopwatch stopWatch;
	private int elapsedTime;

	/* ログ用ファイル */
	private File file;
	private FileOutputStream fos;
	private DataOutputStream dos;

	public LineTracer() {
		brightness = 0;
		available = true;
		forward = 0;
		turn = 0;
		pause = false;

		deviation = 0;
		preDeviation = 0;
		prePreDeviation = 0;

		stopWatch = new Stopwatch();
		stopWatch.reset();

//		file = new File("logfile.txt");
		file = null;
//		try {
//			file.createNewFile();
//		} catch (IOException e1) {
//			LCD.drawString("couldn't new file",0, 0);
//			file = null;
//			return;
//		}
//		fos = new FileOutputStream(file);
//		dos = new DataOutputStream (fos);
//		try {
//			dos.writeChars("Time, lightDowned,lightUpped, brightness\n");
//		} catch (IOException e) {
//			file = null;
//			return;
//		}
	}

	/* ライントレース */
	public void run() {
		/* LEDをONしないで光センサから値を取る方法を確認する */
		light.readNormalizedValue(); /* 光センサ赤色LEDをON */

		int distance;	/* cm単位 */
		int counter = 0;
		while (available == true) {

//			/* 超音波センサによる距離測定周期は、超音波の減衰特性に依存します。 */
//			if(++counter == 10) { /* 約40msec周期処理 */
//				distance = sonar.getDistance();
//				/* 障害物が30cm以内にあったらライントレース中止 */
//				if(distance < 30) {
//					forward = 0;
//					pause = true;
//				}
//				else {
//					forward = 50;
//					pause = false;
//				}
//				counter=0;
//			}
			forward = 50;
			switch(++counter){
				case 5:		// lightON
					lightON();	/* 光センサ赤色LEDをON */
					try {
						setBrightness();
					} catch (IOException e1) {
						LCD.drawString("file write error",0, 0);
						file = null;
					}
					break;
				case 10:	// lightOFF
					lightOFF();	/* 光センサ赤色LEDをOFF */
					try {
						setBrightness();
					} catch (IOException e1) {
						LCD.drawString("file write error",0, 0);
						file = null;
					}
					counter=0;
					break;
//				case 7:
//					distance = sonar.getDistance();
//					/* 障害物が30cm以内にあったらライントレース中止 */
//					if(distance < 30) {
//						forward = 0;
//						pause = true;
//					}
//					else {
//						forward = 50;
//						pause = false;
//					}
//					break;
//				case 9:
//					counter=0;
				default:
					// nothing to do
					break;
			}

			if(pause == true) {
				turn = 0;
			}
			else {
				/* ライントレース */
				pidControl();
//				if ((1023 - light.readNormalizedValue()) <= (WHITE + BLACK) / 2) {
//				if(brightness < THRESHOLD){
//					turn = 50F; /* 右折 */
//				}
//				else {
//					turn = -50F; /* 左折 */
//				}
			}
			try {
				Thread.sleep(4); /* 約4msec周期処理 */
			} catch (InterruptedException e) {
			}
		}
	}

	/* 旋回命令取得 */
	public float getTurnCmd() {
		return turn;
	}

	/* 前後進命令取得 */
	public float getForwardCmd() {
		return forward;
	}

	/* ライントレース停止 */
	public void stopRunning() {
		available = false;
//		try {
//			fos.close();
//		} catch (IOException e) {
//		}
	}

	/* 明度計測（ルミノメーター）*/
	private void setBrightness() throws IOException
	{
		int lightDiff;				/* 点灯時と消灯時の変化量	*/
		double k;					/* 光センサー非線形補正値	*/

		if((lightDowned ==0)||(lightUpped==0)){
			return;		// 両方のデータが取れるまでは計算しない
		}
		/* 光センサーの変化量を計算 */
		if (lightDowned - lightUpped > 0) {
			lightDiff = lightDowned - lightUpped;
		} else {
			lightDiff = 0;
		}

		/* 光センサー非線形補正係数を計算 （実験データより） */
		k = (1.0382E-3 * lightDowned - 6.3295E-1) * lightDowned + 1.1024E+2;

		/* コース明度を計算 */
		brightness = lightDiff / k;
		/* 偏差を計算 */
		prePreDeviation = preDeviation;
		preDeviation = deviation;
		deviation = brightness - THRESHOLD;

		/* ログの書き出し */
		if(null != file){
			StringBuffer s = new StringBuffer(50);
			s.append(stopWatch.elapsed());
			s.append(",");
			s.append(lightDowned);
			s.append(",");
			s.append(lightUpped);
			s.append(",");
			s.append(brightness);
			s.append("\n");
//			LCD.drawString("setBrightness",0, 0);
			dos.writeChars(s.toString());
		}

	}

	/* LED OFF時の光センサ値を読み取り、LEDをONにする */
	private void lightON()
	{
		lightDowned = (1023-light.readNormalizedValue());
//		lightDowned = (1023-light.getNormalizedLightValue());
//		lightDowned = light.readValue();
		light.setFloodlight(true);	/* 光センサ赤色LEDをON */
	}

	/* LED ON時の光センサ値を読み取り、LEDをOFFにする */
	private void lightOFF()
	{
		lightUpped = (1023-light.readNormalizedValue());
//		lightUpped = (1023-light.getNormalizedLightValue());
//		lightUpped = light.readValue();
		light.setFloodlight(false);	/* 光センサ赤色LEDをOFF */
	}

	private void pidControl()
	{
		double direction;

		if((lightDowned ==0)||(lightUpped==0)){
			return;		// 両方のデータが取れるまでは計算しない
		}

		/* 操作量＝Kp×偏差＋Ki×偏差の累積値＋Kd×前回偏差との差 */
		/* MVn = MVn-1 + ΔMVn */
		/* ΔMVn = Kp(en-en-1) + Ki en + Kd((en-en-1) - (en-1-en-2)) */
		/* MVn = MVn-1 +
      			 Kp(brightness - preBrightness) +
      			 Ki(brightness - THRESHOLD) +
      			 Kd(brightness - preBrightness*2 + prePreBrightness) */
		direction = KP*(deviation-preDeviation) +
		            KI*deviation +
		            KD*((deviation - preDeviation) - (preDeviation- prePreDeviation));
		turn = (float) (turn+ direction);
	}


}
