<?php
// vim: foldmethod=marker tabstop=4 shiftwidth=4 autoindent
/**
 *  Ethna_CacheManager.php
 *
 *  @author     Masaki Fujimoto <fujimoto@php.net>
 *  @license    http://www.opensource.org/licenses/bsd-license.php The BSD License
 *  @package    Ethna
 *  @version    $Id: 57f79b8b67d6b52f45bace19836000e0edeed02b $
 */

/**
 *  キャッシュマネージャクラス
 *
 *  @author     Masaki Fujimoto <fujimoto@php.net>
 *  @access     public
 *  @package    Ethna
 */
class Ethna_CacheManager
{
    /**
     *  Cachemaanger プラグインのインスタンスを取得する
     *
     *  @param  string  $type   キャッシュタイプ('localfile', 'memcache'...)
     *  @return object  Ethna_Plugin_CacheMaanger   Cachemanager プラグインのインスタンス
     *  @access public
     */
    function &getInstance($type)
    {
        $controller = Ethna_Controller::getInstance();
        $plugin = $controller->getPlugin();

        $cache_manager = $plugin->getPlugin('Cachemanager', ucfirst($type));

        return $cache_manager;
    }
}
