//
// t@C : Main.cpp
// Tv       : 2֓|UqCg[X{bgTOPPERS/ATK1(OSEK)pC++TvvO
//

#include "math.h"

// ECRobot C++ API
#include "TouchSensor.h"
//#include "SonarSensor.h"
#include "LightSensor.h"
#include "GyroSensor.h"
#include "Motor.h"
#include "Nxt.h"
#include "Clock.h"
#include "Lcd.h"
#include "Speaker.h"
using namespace ecrobot;

#include "Driver.h"
#include "TailControl.h"
//#include "NXTway_GS.h"
//#include "Driver.h"
//#include "StartStopDriver.h"
//#include "SonarDriver.h"
//#include "LineTraceDriver.h"
//#include "DriverManager.h"

//#include "SectionKnowledge.h"
//=============================================================================
// foCXIuWFNg̒`
TouchSensor touch(PORT_4);
//SonarSensor sonar(PORT_2);

//LightSensor light(PORT_3);
//GyroSensor   gyro(PORT_1);
//Motor      motorT(PORT_A);
//Motor      motorR(PORT_B);
//Motor      motorL(PORT_C);
//Nxt nxt;
Clock clock;

//for Debug
Lcd* pLcd = new Lcd();

Speaker speaker;

LightSensor* pLightSensor = new LightSensor(PORT_3);
GyroSensor* pGyroSensor = new GyroSensor(PORT_1);
Motor* pMotorT = new Motor(PORT_A);
Motor* pMotorR = new Motor(PORT_B);
Motor* pMotorL = new Motor(PORT_C);
Nxt* pNxt = new Nxt();

bool bStart;

// ^XNR[hCo
//StartStopDriver ssDriver;
//SonarDriver sonarDriver;

extern "C"
{
#include "kernel.h"
#include "kernel_id.h"
#include "ecrobot_interface.h"
//#include "ConfigConst.h"

//=============================================================================
// TOPPERS/ATK1̐錾
DeclareCounter(SysTimerCnt);
DeclareAlarm(Alarm4msec);
DeclareEvent(EventDrive);

// ^XN̋N[msec]
#define DRIVE_PERIOD       (4)
#define BACKGROUND_PERIOD (48)

//=============================================================================
// ֐	: user_1ms_isr_type2
// 	: Ȃ
// ߂l	: Ȃ
// Tv	: 1msec荞݃tbN֐(OSEK ISR type2JeS)
//=============================================================================
void user_1ms_isr_type2(void)
{
	(void)SignalCounter(SysTimerCnt); // AlarmϥɥE
	SleeperMonitor(); // NxtI2CfoCX̎gpɕKv
}

//=============================================================================
// ^XN@: TaskMain
// Tv	@: C^XN
//=============================================================================
TASK(TaskMain)
{
	pLcd->clear();
	pLcd->putf("s", "TOUCH:START/STOP");
	pLcd->disp();
	
	SetRelAlarm(Alarm4msec, 1, DRIVE_PERIOD); // hCupAlarm^C}[̃Zbg
	
	bStart = false;
	
	while(1)
	{
		// ^b`ZT̏Ԃo
		if (touch.isPressed() == true){
			
			pLcd->putf("s", "TOUCH:On");
			pLcd->disp();
			
			if (bStart == false){
				bStart = true;
			} else {
				bStart = false;
			}
			
		} 
		//sonarDriver.checkObstacles(sonar); // gZTɂQo

		clock.wait(BACKGROUND_PERIOD); // EFCg[v
	}
}

//=============================================================================
// ^XN@: TaskDrive
// Tv	@: hCu^XN
//=============================================================================
TASK(TaskDrive)
{
/*
	LineTraceDriver ltDriver(light);
		
	DriverManager drivers;
	//(void)drivers.createDriverTable(3);
	(void)drivers.createDriverTable(2);
	(void)drivers.add(&ssDriver); // ōDx
	//(void)drivers.add(&sonarDriver);
	(void)drivers.add(&ltDriver); // ŒDx
	
	//ʒuvɕKvȂ(dWRadius, dWInterval͑ŝĒ)
	float dX = 0.0;
	float dY = 0.0;
	float dW = 0.0;
	float dPI = 2 * asin(1);
	float dWRadius = 0.04; 		// ԗ֔a(m)
	float dWInterval = 0.16;	// ԗ֊Ԋu(m)
	S32   lLastLRotAngle = 0;
	S32   lLastRRotAngle = 0;
	long  lSampling = 0;		// vԊu

	NXTway_GS robot(nxt, gyro, motorL, motorR);

	while(1)
	//while(know.next(sect))
	{
        ClearEvent(EventDrive); // hCuCxg̃NA
		WaitEvent(EventDrive);  // hCuCxg҂

		drivers.notify(robot.readInternalData()); // ŝ̓f[^hCo[֒ʒm
		drivers.update(); // hCoNGXg擾OɍXV
		switch(drivers.getRequest())
		{
			case Driver::STOP:
				robot.stop();
				break;
			case Driver::START:
				CancelAlarm(Alarm4msec);            // hCupAlarm^C}[̃LZ

				robot.reset(robot.calGyroOffset()); // WCZT̃Lu[Vɖ400msec
				drivers.reset();
				//speaker.playTone(440U, 500U, 30U);  // ZbgʒmuU[

				//ʒȕ
				dX = 0.0;
				dY = 0.0;
				dW = 0.0;
				lLastLRotAngle = 0;
				lLastRRotAngle = 0;
				lSampling = 0;

				ltDriver.setSpeed(50);

				SetRelAlarm(Alarm4msec, 1, DRIVE_PERIOD); // hCupAlarm^C}[̃Zbg
				break;
			case Driver::DRIVE: 
			
				//̓TvB
				if(dY < -0.3){
					ltDriver.setSpeed(80);
				}else if(dX < -0.3){
					ltDriver.setSpeed(20);
				}else{
					ltDriver.setSpeed(40);
				}
			
				robot.drive(drivers.getCommand());
				break;
			case Driver::NO_REQ:
			default:
				break; // Do nothing
		}

		if(lSampling > 50){
			
			//^C̉]ʂvZ
			S32 lMoveL = motorL.getCount() - lLastLRotAngle;
			S32 lMoveR = motorR.getCount() - lLastRRotAngle;

			float dMoveL = dPI * dWRadius * (F32)(lMoveL) / 180.0;
			float dMoveR = dPI * dWRadius * (F32)(lMoveR) / 180.0;
			
			float dVt =  (dMoveR + dMoveL) / 2.0;
			float dWt =  (dMoveR - dMoveL) / dWInterval;
			
			//ʒuvZ
			if (lMoveR == lMoveL){
				//i
				dX = dX + dVt * cos(dW);
				dY = dY + dVt * sin(dW);
				
			}else{
				//J[u
				dX = dX + 2 * (dVt / dWt) * sin(dWt / 2) * cos(dW + dWt / 2);
				dY = dY + 2 * (dVt / dWt) * sin(dWt / 2) * sin(dW + dWt / 2);
			}
			dW = dW + dWt;

			//
			lLastLRotAngle = motorL.getCount();
			lLastRRotAngle = motorR.getCount();
			
			lSampling = 0;
		}else{
			lSampling++;
		}

		//j^ɕ\
		lcd.clear();
		S32 sx = static_cast<S32>(100 * dX);				// cm
		S32 sy = static_cast<S32>(100 * dY);				// cm
		S32 sw = static_cast<S32>(180 * dW / dPI);		// x\
		lcd.putf("sdn",  "x: ", sx,0);
		lcd.putf("sdn",  "y: ", sy,0);
		lcd.putf("sdn",  "w: ", sw,0);
		lcd.disp();
	}

*/	
	TailControl* pTailControl = new TailControl(pMotorT);
	Driver* pDriver = new Driver(pLightSensor, pGyroSensor, pMotorL, pMotorR, pNxt, pLcd, pTailControl);
	
	CancelAlarm(Alarm4msec); 
	SetRelAlarm(Alarm4msec, 1, DRIVE_PERIOD); // hCupAlarm^C}[̃Zbg
	while(1){
        ClearEvent(EventDrive); // hCuCxg̃NA
		WaitEvent(EventDrive);  // hCuCxg҂
		pTailControl->tail_control(TAIL_ANGLE_STAND_UP);
		if (bStart == true){
			pDriver->run();
		}
	}
	
	delete pTailControl;
	delete pLightSensor;
	delete pGyroSensor;
	delete pMotorT;
	delete pMotorR;
	delete pMotorL;
	delete pNxt;

}
};

