//
// PIDCtrl.h
//

#ifndef PIDCTRL_H_
#define PIDCTRL_H_

#include "LightSensor.h"
using namespace ecrobot;

/**
 * @brief PIDNX
 * PIDʂZo܂B
 *
 * Iʂ̎Zo͏ȗĂ܂B
 */
class PIDCtrl
{
public:

	//
	// Default light sensor value for white color
	//
	static const S16 DEFAULT_BLACK = 700;

	//
	// Default light sensor value for black color
	//
	static const S16 DEFAULT_WHITE = 520;

	//
	// Constructor
	//
	// @param tgtVal ڕWl
	// @param kp PQCl
	// @param ki IQCl
	// @param kd DQCl
	PIDCtrl(LightSensor* pLightSensor, float tgtVal, float kp, float ki, float kd);
 
	~PIDCtrl();

	//
	// 񑬓xZo
	//
	// @retval S16 PID
	S16 calcVal();
	
	//
	// ZT̃ItZbglݒ肷
	//
	// @param black Light sensor value for black
	// @param white Light sensor value for white
	void setColorRef(S16 black, S16 white);
	
	S16 getlightValue();


private:
	
	//
	// ڕWl
	//
	const float TGT_VAL;
	
	//
	// PQCl
	//
	const float KP;
	
	//
	// IQCl
	//
	const float KI;
	
	//
	// DQCl
	//
	const float KD;
	
	//
	// O΍
	//
	float m_prevDiff;

	//
	// ZT
	//
	LightSensor* m_pMyLightSensor;
	
	//
	// ZT̃ItZbgl
	//
	S16 m_Black;
	S16 m_White;

	//
	// PʎZo
	//
	// @param diff ݒl
	// @retval float P
	float calcPVal(float diff);

	//
	// IʎZo
	//
	// @brief Ȃ
	float calcIVal(float diff);

	//
	// DʎZo
	//
	// @param diff ݒl
	// @retval float D
	float calcDVal(float diff);
};

#endif /*PIDCTRL_H_*/
