//
// եE : Main.cpp
//        : 2Ωҥ饤ȥEܥåȤTOPPERS/ATK1(OSEK)C++ץEץ饁E
//

#include "math.h"

// ECRobot C++ API
#include "TouchSensor.h"
#include "SonarSensor.h"
#include "LightSensor.h"
#include "GyroSensor.h"
#include "Motor.h"
#include "Nxt.h"
#include "Clock.h"
#include "Lcd.h"
#include "Speaker.h"
using namespace ecrobot;

#include "NXTway_GS.h"
#include "Driver.h"
#include "StartStopDriver.h"
#include "SonarDriver.h"
#include "LineTraceDriver.h"
#include "DriverManager.h"

#include "SectionKnowledge.h"
//=============================================================================
// ǥХ֥ȤāE
TouchSensor touch(PORT_4);
SonarSensor sonar(PORT_2);
LightSensor light(PORT_3);
GyroSensor   gyro(PORT_1);
Motor      motorR(PORT_B);
Motor      motorL(PORT_C);
Clock clock;
Lcd lcd;
Nxt nxt;
Speaker speaker;

// ʣ饳EEEɥ饤
StartStopDriver ssDriver;
SonarDriver sonarDriver;

extern "C"
{
#include "kernel.h"
#include "kernel_id.h"
#include "ecrobot_interface.h"
#include "ConfigConst.h"

//=============================================================================
// TOPPERS/ATK1E
DeclareCounter(SysTimerCnt);
DeclareAlarm(Alarm4msec);
DeclareEvent(EventDrive);

// εưEmsec]
#define DRIVE_PERIOD       (4)
#define BACKGROUND_PERIOD (48)

//=============================================================================
// ؿ̾	: user_1ms_isr_type2
// E: ʤ
// ᤁE	: ʤ
// 	: 1msecE䤁EߥեåؿEOSEK ISR type2ƥE
//=============================================================================
void user_1ms_isr_type2(void)
{
	(void)SignalCounter(SysTimerCnt); // AlarmϥɥE
	SleeperMonitor(); // NxtI2CǥХλѻɬ
}

//=============================================================================
// ̾: TaskMain
// 	: ᥤ󥿥
//=============================================================================
TASK(TaskMain)
{
	lcd.clear();
	lcd.putf("s", "TOUCH:START/STOP");
	lcd.disp();

	SetRelAlarm(Alarm4msec, 1, DRIVE_PERIOD); // ɥ饤AlarmޡΥå

	while(1)
	{
		ssDriver.checkInput(touch.isPressed()); // å󥵤ξ֤򸡽
		sonarDriver.checkObstacles(sonar); // Ķȥ󥵤ˤ褁E㳲ʪ

		clock.wait(BACKGROUND_PERIOD); // ȥE
	}
}

//=============================================================================
// ̾: TaskDrive
// 	: ɥ饤֥
//=============================================================================
TASK(TaskDrive)
{
	LineTraceDriver ltDriver(light);
		
	DriverManager drivers;
	(void)drivers.createDriverTable(3);
	(void)drivers.add(&ssDriver); // ǹͥ
	(void)drivers.add(&sonarDriver);
	(void)drivers.add(&ltDriver); // ͥ

	NXTway_GS robot(nxt, gyro, motorL, motorR);
	
	
	float fPI = 2.0 * asin(1);	// ߼Ψ
	float fWRadius     = 40;	// Ⱦ(mm)
	F32 fDist          = 0.0;	// Υmm
	F32 fTarget        = 0.0;
	
	//long lCnt = 0;
	//bool bFlg = false;
	SectionKnowledge know;
	st_section sect;
	sect.lDistance_mm = 0;
	sect.lSpeed       = 0;
	sect.bLineTrace   = true;
	while(1)
	//while(know.next(sect))
	{
        ClearEvent(EventDrive); // ɥ饤֥٥ȤΥE
		WaitEvent(EventDrive);  // ɥ饤֥٥Ԥ
		
		drivers.notify(robot.readInternalData()); // Τǡɥ饤С
		drivers.update(); // ɥ饤ХEȤE˹
		switch(drivers.getRequest())
		{
			case Driver::STOP:
				robot.stop();
				break;
			case Driver::START:
				CancelAlarm(Alarm4msec);            // ɥ饤AlarmޡΥ󥻥E
				robot.reset(robot.calGyroOffset()); // 㥤󥵤Υ㥁E֥ÉE00msecE
				drivers.reset();
				//speaker.playTone(440U, 500U, 30U);  // EåȴλΥ֥
				SetRelAlarm(Alarm4msec, 1, DRIVE_PERIOD); // ɥ饤AlarmޡΥå
				//ltDriver.setSpeed(50);
			
				fDist          = 0.0;
				know.next(sect);
				fTarget += sect.lDistance_mm;
				ltDriver.setSpeed(sect.lSpeed);
				ltDriver.setCurveSet(sect.bLineTrace);
				break;
			case Driver::DRIVE: 
				/*
				if (!bFlg) {
					lCnt++;
					if (lCnt > 1000) {
						bFlg = true;
						ltDriver.setSpeed(110);
					}
				}
				*/

				if(fDist > fTarget) {
					if (know.next(sect) == true) {
//				speaker.playTone(840U, 500U, 50U);  // EåȴλΥ֥
						fTarget += sect.lDistance_mm;
						ltDriver.setSpeed(sect.lSpeed);
						ltDriver.setCurveSet(sect.bLineTrace);
					} else {
						//ָEλʤΤǥȥå
						ltDriver.setSpeed(0);
						fTarget += 10000;
						
					}
				}
				
				robot.drive(drivers.getCommand());
				break;
			case Driver::NO_REQ:
			default:
				break; // Do nothing
		}

		fDist = fWRadius * fPI * static_cast<F32>(motorR.getCount()) / 180.0;

	}
}
};

