///////////////////////////////////////////////////////////
//  UI.cpp
//  Implementation of the Class UI
//  Created on:      09-7-2011 20:24:52
//  Original author: u90499
///////////////////////////////////////////////////////////

#include "UI.h"
#include "Clock.h"

#include <string.h>
#include <stdio.h>


#define BACKGROUND_PERIOD (48)

UI::UI(LightSensor* pLightSensor, TouchSensor* pTouchSensor,SonarSensor* pSoner, Nxt* pNxt, Lcd* pLcd, DriverMgr* pDriverMgr){
	m_light = pLightSensor;
	m_touch = pTouchSensor;
	m_pNxt = pNxt;
	m_pLcd = pLcd;
	m_DriverMgr = pDriverMgr;
	m_bTaskActive = true;
	m_pSoner = pSoner;
}

UI::~UI(){
}

void UI::printCourceSelect(){
	printData("Select Couse\nIn/Out",2000);
}

void UI::selectCource(Em_CourseKind::eCourseKind& eInOutFlag, bool& bDifficultStageFlag){


//	bool bOKNGflag = false;
	
//	do{
		
		//
		// Cource select
		//
		printCourceSelect();
		if(selectBotton("In","Out") == true) eInOutFlag = Em_CourseKind::IN;
		else eInOutFlag = Em_CourseKind::OUT;
		eInOutFlag = Em_CourseKind::NONE;
		
		//
		// DifficultStage select
		//
		//printDifficultStage();
		//bDifficultStageFlag = selectBotton("Exec","None");

		//
		// OK/NG select
		//
		
		printResult(eInOutFlag, bDifficultStageFlag);
//		bOKNGflag = selectOKNG();

//	}while(!bOKNGflag);
}

void UI::waitForTouchSenserOn(){
	Clock clock;
#ifdef ENABLE_BT_START
	U32 rx_len = 0;
	CHAR buf[BT_MAX_RX_BUF_SIZE];
#endif

	printData("TOUCH:START/STOP",1000);

	bool bStartFlag = false;
	bool bDoObstaclesExist = false;

	while(m_bTaskActive == true)
	{
#ifdef ENABLE_BT_START
		// Bluetooth ̃obt@NAAf[^M󂯂
		rx_len = ecrobot_read_bt(buf, 0, BT_MAX_RX_BUF_SIZE);
		// ^b`ZT̏ԂoA܂Bluetooth̐Mi"r"L[jM
		if ((m_touch->isPressed() == true) || ((rx_len > 0) && (strcmp(buf, "r") == 0))) {
#else
		if (m_touch->isPressed() == true) {
#endif
			bStartFlag = (bStartFlag == false) ? true : false;
			m_DriverMgr->notifyStart(bStartFlag);
		}
		
		bDoObstaclesExist  = (m_pSoner->getDistance() <= 25) ? true : false;
		m_DriverMgr->notifyObstaclesExist(bDoObstaclesExist);
		
		clock.wait(BACKGROUND_PERIOD);
	}
}


bool UI::selectOKNG(){
	printData("Result Select\nOK/NG?",2000);
	bool bOKNGflag = selectBotton("OK","NG");
	
	if(bOKNGflag == true) printData("GOGO!",1000);
	else printData("ReENTR ;;",1000);
	return bOKNGflag;
}

void UI::printDifficultStage(){
	printData("Select\nDifficult Stage\nExec/None", 2000);
}

void UI::printResult(Em_CourseKind::eCourseKind eInOutFlag, bool bDifficultStageFlag){

	
	CHAR chComment[32] = {""};
	
	if(eInOutFlag == Em_CourseKind::IN)	sprintf(chComment,"Cource:In\n");
	else if(eInOutFlag == Em_CourseKind::OUT) sprintf(chComment,"Cource:Out\n");
	else sprintf(chComment,"Cource:NONE\n");
		
	if(bDifficultStageFlag == true)	strcat(chComment,"Nansho:Exec");
	else strcat(chComment,"Nansho:None");
	
	printData(chComment, 2000);
}


void UI::printcalibration(){
	printData("calibration Exec",2000);
	
	Nxt nxt;
	Clock clock;
	Lcd lcd;

	bool bOKNGflag = false;
	do{

		S16 sBlack = calibrate("Black:");
		S16 sWhite = calibrate("White:");

		lcd.clear();
		lcd.putf("sdn", "Black:", long(sBlack), 0);
		lcd.putf("sdn", "White:", long(sWhite), 0);
		lcd.disp();
		clock.wait(2000);
		
		bOKNGflag = selectOKNG();
		

		clock.wait(3000);
	}while(!bOKNGflag);
}


S16 UI::calibrate(char* chData){
	S16 sBrightData = 0;
	
	while(1){
		sBrightData = m_light->get();

		m_pLcd->clear();
		m_pLcd->putf("sdn", chData, long(sBrightData), 0);
		m_pLcd->disp();

		if (m_pNxt->getButtons() == Nxt::ENTR_ON){
			break;
		}
	}
	
	Clock clock;
	clock.wait(2000);
	
	return sBrightData;
}


void UI::printData(char* str,int SleepTme){

	m_pLcd->clear();
	m_pLcd->putf("sn", str);
	m_pLcd->disp();

	Clock clock;
	clock.wait(SleepTme);
}


bool UI::selectBotton(CHAR chTrueData[],CHAR chFalseData[]){
	Nxt nxt;
	Clock clock;

	bool bflag  = true;
	printData(chTrueData,0);

	while(1){

		
		if (nxt.getButtons() == Nxt::RUN_ON){
			if(bflag == true){
				 bflag  = false;
			}
			else{
				bflag  = true;
			}
			if(bflag == true){
				printData(chTrueData, 0);
			}else{
				printData(chFalseData, 0);
			}
		}
		clock.wait(1000);
		if (nxt.getButtons() == Nxt::ENTR_ON){
			break;
		}
	}
	return bflag;
}
