///////////////////////////////////////////////////////////
//  DriverMgr.h
//  Implementation of the Class DriverMgr
//  Created on:      14-7-2011 17:15:33
//  Original author: u90499
///////////////////////////////////////////////////////////

#ifndef DriverMgr_H_
#define DriverMgr_H_

#include "Vector.h"
using namespace ecrobot;

extern "C"
{
	#include "ecrobot_interface.h"
};

#include "math.h"
#include "LightSensor.h"
#include "PIDCtrl.h"
#include "StandControl.h"
#include "PositionControl.h"
#include "SonarSensor.h"
#include "TailControl.h"
#include "Driver.h"
#include "CourseMgr.h"
#include "Motor.h"
// TOPPERS/ATK1̐錾
DeclareCounter(SysTimerCnt);
DeclareAlarm(Alarm4msec);
DeclareEvent(EventDrive);

#define DRIVE_PERIOD       (4)


class DriverMgr
{

public:

	//
	// Constructor
	//
	DriverMgr(LightSensor* pLightSensor, GyroSensor* pGyroSensor, SonarSensor* pSoner,Motor* pMotorL, Motor* pMotorR, Nxt* pNxt, Lcd* pLcd, TailControl* pTailControl,CourseMgr* pCourseMgr);

	virtual ~DriverMgr();

	//
	// sJn
	//
	void startDrive();
	
	
	//
	// s@쐬
	//
	void createDriver();

	void notifyStart(bool bStartFlag){m_bStartFlag = true;}
	
	void notifyTaskEnd(){m_bTaskActive = false;}

	void notifyObstaclesExist(bool bDoObstaclesExist){m_bDoObstaclesExist = bDoObstaclesExist;}

private:

	bool m_bStartFlag;
	
	bool m_bTaskActive;
	
	bool m_bDoObstaclesExist;

	TailControl* m_pTailControl;
	
	CourseMgr* m_pCourseMgr;
	
	Driver* m_pDriver;
	
	Motor* m_pMotorR;

};
#endif
