//
// Driver.h
//

#ifndef DRIVER_H_
#define DRIVER_H_


#include "LightSensor.h"
#include "PIDCtrl.h"
#include "StandControl.h"
#include "PositionControl.h"
#include "TailControl.h"
using namespace ecrobot;

//for Debug
#include "Lcd.h"

class Driver
{
public:

	/**
	 * Constructor.
	 */
	Driver(LightSensor* pLightSensor, GyroSensor* pGyroSensor, Motor* pMotorL, Motor* pMotorR, Nxt* pNxt, Lcd* pLcd, TailControl* pTailControl);
	
	~Driver();
	
	void run();

private:
	PIDCtrl* m_pPIDCtrl;
	StandControl* m_pStandControl;
	TailControl* m_pTailControl;
	PositionControl* m_pPositionControl;
	S16 m_speed;
	
};

#endif
