//
// ե: Main.cpp
//        : 2Ωҥ饤OPPERS/ATK1(OSEK)C++
//

#include "math.h"


// ECRobot C++ API
#include "TouchSensor.h"
#include "SonarSensor.h"
#include "LightSensor.h"
#include "GyroSensor.h"
#include "Motor.h"
#include "Nxt.h"
#include "Clock.h"
#include "Lcd.h"
#include "Speaker.h"
using namespace ecrobot;

#include "NXTway_GS.h"
#include "Driver.h"
#include "StartStopDriver.h"
#include "SonarDriver.h"
#include "LineTraceDriver.h"
#include "DriverManager.h"

#include "CourseMgr.h"
//=============================================================================
// ǥХ֥Ȥ
TouchSensor touch(PORT_4);
LightSensor light(PORT_3);
SonarSensor sonar(PORT_2);
GyroSensor   gyro(PORT_1);
Motor      motorR(PORT_B);
Motor      motorL(PORT_C);
Clock clock;
Nxt nxt;
Speaker speaker;

// ʣ饳
StartStopDriver ssDriver;
SonarDriver sonarDriver;
LineTraceDriver ltDriver(light);
#include "StartStopDriver.h"

extern "C"
{
#include "kernel.h"
#include "kernel_id.h"
#include "ecrobot_interface.h"
#include "ConfigConst.h"
#include "Monitor.h"
#include "UI.h"
#include "stdio.h"
//=============================================================================
// TOPPERS/ATK1οE
DeclareCounter(SysTimerCnt);
DeclareAlarm(Alarm4msec);
DeclareEvent(EventDrive);
UI ui;
bool bInOutFlag;
// εưEmsec]
#define DRIVE_PERIOD       (4)
#define BACKGROUND_PERIOD (48)

#define TAIL_ANGLE_STAND_UP 108 /* ߻γ[] */
#define TAIL_ANGLE_DRIVE      3 /* ХԻγ[] */
#define P_GAIN             2.5F /* ѥ⡼㷸 */
#define PWM_ABS_MAX          60 /* ѥ⡼PWMк */

//*****************************************************************************
// ؿ̾ : tail_control
//   : angle (⡼ɸ[])
// ֤ : ̵
//  : δѥ⡼γ
//*****************************************************************************
static void tail_control(signed int angle)
{
	float pwm = (float)(angle - nxt_motor_get_count(NXT_PORT_A))*P_GAIN; /*  */
	/* PWM˰½ */
	if (pwm > PWM_ABS_MAX)
	{
		pwm = PWM_ABS_MAX;
	}
	else if (pwm < -PWM_ABS_MAX)
	{
		pwm = -PWM_ABS_MAX;
	}

	nxt_motor_set_speed(NXT_PORT_A, (signed char)pwm, 1);
}

//=============================================================================
// ؿ̾	: user_1ms_isr_type2
// E: ʤ
// E͉: ʤ
// 	: 1msecE䤡ߥեåؿOSEK ISR type2ƥE
//=============================================================================
void user_1ms_isr_type2(void)
{
	(void)SignalCounter(SysTimerCnt); // AlarmϥɥE
	SleeperMonitor(); // NxtI2CǥХλѻɬ
}

//=============================================================================
// ̾: TaskMain
// 	: ᥤ󥿥
//=============================================================================
TASK(TaskMain)
{
	
	SetRelAlarm(Alarm4msec, 1, DRIVE_PERIOD); // ɥ饤AlarmޡΥå

	bool bOKNGflag = false;
	ui.set_ssDriver(&ssDriver);
	ui.set_ltDriver(&ltDriver);
	ui.set_TouchSensor(&touch);
	ui.set_LightSensor(&light);
	
	do{
		
		//
		// Cource select
		//
		ui.printCourceSelect();
		bInOutFlag = ui.selectBotton("In","Out");
		
		
		//
		// DifficultStage select
		//
		ui.printDifficultStage();
		bool bDifficultStageFlag = ui.selectBotton("Exec","None");

		
		//
		// OK/NG select
		//
		ui.printResult(bInOutFlag, bDifficultStageFlag);
		bOKNGflag = ui.selectOKNG();
		ui.printResult(bInOutFlag, bDifficultStageFlag);

	}while(!bOKNGflag);


	ui.printcalibration();

	ui.waitForTouchSenserOn();
	
}

//=============================================================================
// ̾: TaskDrive
// 	: ɥ饤֥
//=============================================================================
TASK(TaskDrive)
{

		
	DriverManager drivers;
	(void)drivers.createDriverTable(3);
	(void)drivers.add(&ssDriver); // ǹͥ
//	(void)drivers.add(&sonarDriver);
	(void)drivers.add(&ltDriver); // ͥ

	NXTway_GS robot(nxt, gyro, motorL, motorR);
	
	
	float fPI = 2.0 * asin(1);	// ߼Ψ
	float fWRadius     = 40;	// Ⱦ(mm)
	F32 fDist          = 0.0;	// Υmm
	F32 fTarget        = 0.0;
	
	//long lCnt = 0;
	//bool bFlg = false;
	CourseMgr courseMgr;
	courseMgr.createCourse(bInOutFlag);
	st_section sect;
	sect.lDistance_mm = 0;
	sect.lSpeed       = 0;
	sect.bLineTrace   = true;
	while(1)
	//while(know.next(sect))
	{
        ClearEvent(EventDrive); // ɥ饤֥٥ȤΥEE
		WaitEvent(EventDrive);  // ɥ饤֥٥Ԥ
		
		drivers.notify(robot.readInternalData()); // Τǡɥ饤С
		drivers.update(); // ɥ饤ХEȤ˹E
		switch(drivers.getRequest())
		{
			case Driver::STOP:
				tail_control(TAIL_ANGLE_STAND_UP); /* ѳ٤E*/
				robot.stop();
				break;
			case Driver::START:
				CancelAlarm(Alarm4msec);            // ɥ饤AlarmޡΥ󥻥E
				robot.reset(robot.calGyroOffset()); // 㥤󥵤Υ㥁E̡֥00msecE
				drivers.reset();
				//speaker.playTone(440U, 500U, 30U);  // EåȴλΥ֥E
				SetRelAlarm(Alarm4msec, 1, DRIVE_PERIOD); // ɥ饤AlarmޡΥå
				//ltDriver.setSpeed(50);
			
				fDist          = 0.0;
				courseMgr.getNextSection(sect);
				fTarget += sect.lDistance_mm;
				ltDriver.setSpeed(sect.lSpeed);
				ltDriver.setCurveSet(sect.bLineTrace);
				tail_control(TAIL_ANGLE_DRIVE); /* ѳ٤E*/
				break;
			case Driver::DRIVE: 
				/*
				if (!bFlg) {
					lCnt++;
					if (lCnt > 1000) {
						bFlg = true;
						ltDriver.setSpeed(110);
					}
				}
				*/
				if(fDist > fTarget) {
					if (courseMgr.getNextSection(sect) == true) {
//				speaker.playTone(840U, 500U, 50U);  // EåȴλΥ֥E
						fTarget += sect.lDistance_mm;
						ltDriver.setSpeed(sect.lSpeed);
						ltDriver.setCurveSet(sect.bLineTrace);
					} else {
						//ָEλʤΤǥȥåׁE
						ltDriver.setSpeed(0);
						fTarget += 10000;
						
					}
				}
				
				robot.drive(drivers.getCommand());
				break;
			case Driver::NO_REQ:
			default:
				break; // Do nothing
		}

		fDist = fWRadius * fPI * static_cast<F32>(motorR.getCount()) / 180.0;
	}
}
};
