///////////////////////////////////////////////////////////
//  UI.cpp
//  Implementation of the Class UI
//  Created on:      09-7-2011 20:24:52
//  Original author: u90499
///////////////////////////////////////////////////////////

#include "UI.h"
#include "TouchSensor.h"
#include "Clock.h"
#include "Nxt.h"
#include <string.h>
#include <stdio.h>


#define BACKGROUND_PERIOD (48)


Clock clock;


UI::UI(){
	m_monitor = new Monitor();
}



UI::~UI(){
	delete m_monitor;
}


/*


void UI::Enter{^ʒm(){

}


void UI::Run{^ʒm(){

}


void UI::Lu[Vʂ\(){

}
*/

void UI::printCourceSelect(){
	m_monitor->printData("Select Couse\nIn/Out",2000);
}

void UI::waitForTouchSenserOn(){
	m_monitor->printData("TOUCH:START/STOP",1000);
	while(1)
	{
		m_ssDriver->checkInput(m_touch->isPressed());
		clock.wait(BACKGROUND_PERIOD);
	}

}

bool UI::selectOKNG(){
	m_monitor->printData("Result Select\nOK/NG?",2000);
	bool bOKNGflag = selectBotton("OK","NG");
	
	if(bOKNGflag == true) m_monitor->printData("GOGO!",1000);
	else m_monitor->printData("ReENTR ;;",1000);
	return bOKNGflag;
}




void UI::notifyTouchSenserPut(){

}

void UI::printDifficultStage(){
	m_monitor->printData("Select\nDifficult Stage\nExec/None", 2000);
}

void UI::printResult(bool bInOutFlag, bool bDifficultStageFlag){

	
	CHAR chComment[32] = {""};
	
	if(bInOutFlag == true)	sprintf(chComment,"Cource:In\n");
	else sprintf(chComment,"Cource:Out\n");
		
	if(bDifficultStageFlag == true)	strcat(chComment,"Nansho:Exec");
	else strcat(chComment,"Nansho:None");
	
	m_monitor->printData(chComment, 5000);
}




bool UI::selectBotton(CHAR chTrueData[],CHAR chFalseData[]){
	Nxt nxt;
	Clock clock;

	bool bflag  = true;
	m_monitor->printData(chTrueData,0);

	while(1){

		
		if (nxt.getButtons() == Nxt::RUN_ON){
			if(bflag == true){
				 bflag  = false;
			}
			else{
				bflag  = true;
			}
			if(bflag == true){
				m_monitor->printData(chTrueData, 0);
			}else{
				m_monitor->printData(chFalseData, 0);
			}
		}
		clock.wait(1000);
		if (nxt.getButtons() == Nxt::ENTR_ON){
			break;
		}
	}
	return bflag;
}
#include "Lcd.h"

void UI::printcalibration(){
	m_monitor->printData("calibration Exec",2000);
	
	Nxt nxt;
	Clock clock;
	Lcd lcd;

	bool bOKNGflag = false;
	do{

		m_monitor->printData("Black Get",2000);
		S16 sBlack = calibrate("Black:");
		m_monitor->printData("White Get",2000);
		S16 sWhite = calibrate("White:");

		lcd.clear();
		lcd.putf("sddn", "Black:", sBlack, 0);
		lcd.putf("sddn", "White:", sWhite, 0);
		lcd.disp();
		clock.wait(2000);
		
		bOKNGflag = selectOKNG();
		
		lcd.clear();
		lcd.putf("sddn", "Black:", sBlack, 0);
		lcd.putf("sddn", "White:", sWhite, 0);
		lcd.disp();
		clock.wait(3000);
	}while(!bOKNGflag);


}


S16 UI::calibrate(char* chData){
	Nxt nxt;
	Clock clock;
	S16 sBrightData = 0;
	while(1){
		sBrightData = m_light->getBrightness();
		m_monitor->printData(chData,sBrightData, 0);

		clock.wait(1000);
		if (nxt.getButtons() == Nxt::ENTR_ON){
			break;
		}
	}
	return sBrightData;
}

