//
// t@C : Main.cpp
// Tv       : 2֓|UqCg[X{bgTOPPERS/ATK1(OSEK)pC++TvvO
//

//#include "math.h"

// ECRobot C++ API
#include "TouchSensor.h"
//#include "SonarSensor.h"
#include "LightSensor.h"
#include "GyroSensor.h"
#include "Motor.h"
#include "Nxt.h"
#include "Clock.h"
#include "Lcd.h"
//using namespace ecrobot;

#include "UI.h"
#include "Driver.h"
#include "DriverMgr.h"
#include "TailControl.h"
#include "CourseMgr.h"
#include "Em_CourseKind.h"

//=============================================================================
// foCXIuWFNg̒`

Clock clock;

GyroSensor gyro(PORT_1);
LightSensor light(PORT_3);
TouchSensor touch(PORT_4);
Motor motorT(PORT_A);
Motor motorR(PORT_B);
Motor motorL(PORT_C);


Nxt nxt;
Lcd lcd;
UI ui;
CourseMgr courseMgr;

bool bInOutFlag = false;
bool bDifficultStageFlag;

extern "C"
{
//=============================================================================

// ^XN̋N[msec]
#define BACKGROUND_PERIOD (48)

//=============================================================================
// ֐	: user_1ms_isr_type2
// 	: Ȃ
// ߂l	: Ȃ
// Tv	: 1msec荞݃tbN֐(OSEK ISR type2JeS)
//=============================================================================
void user_1ms_isr_type2(void)
{
	(void)SignalCounter(SysTimerCnt); // Alarmnh
	SleeperMonitor(); // NxtI2CfoCX̎gpɕKv
}

//=============================================================================
// ^XN@: TaskMain
// Tv	@: C^XN
//=============================================================================
TASK(TaskMain)
{
	
	SetRelAlarm(Alarm4msec, 1, DRIVE_PERIOD);

	ui.set_TouchSensor(&touch);
	ui.set_LightSensor(&light);
	
	ui.selectCource(bInOutFlag, bDifficultStageFlag);
	courseMgr.createCourse(static_cast<Em_CourseKind::eCourseKind>(bInOutFlag));

//	ui.printcalibration();

	//XXX fujino
	ui.waitForTouchSenserOn();

	
}

//=============================================================================
// ^XN@: TaskDrive
// Tv	@: hCu^XN
//=============================================================================
TASK(TaskDrive)
{
	TailControl* pTailControl = new TailControl(&motorT);
	
	DriverMgr* pDriverMgr = new DriverMgr(&light, &gyro, &motorL, &motorR, &nxt, &lcd, pTailControl, &courseMgr);
	ui.set_DriverMgr(pDriverMgr);

	pDriverMgr->startDrive();

	
	delete pTailControl;
}
};
