//
// Driver.h
//

#ifndef DRIVER_H_
#define DRIVER_H_

#include "SonarSensor.h"
#include "LightSensor.h"
#include "PIDCtrl.h"
#include "StandControl.h"
#include "PositionControl.h"
#include "TailControl.h"
#include "Section.h"
#include "Em_CourseKind.h"
#include "Em_LookUpRunState.h"
#include "Em_ETSumoRunState.h"

using namespace ecrobot;

//for Debug
#include "Lcd.h"

class Driver
{
public:

	//
	// Constructor
	//
	Driver(LightSensor* pLightSensor, GyroSensor* pGyroSensor, SonarSensor* pSoner,Motor* pMotorL, Motor* pMotorR, Nxt* pNxt, Lcd* pLcd, TailControl* pTailControl);
	
	~Driver();
	
	//
	// s
	//
	void run();

	//
	// sI
	//
	bool isSenctionEnd();
	
	
	void initialize();
	void setRunWay(st_section& sect);
	void notifyObstaclesExist(bool bDoObstaclesExist){m_bDoObstaclesExist = bDoObstaclesExist;}
	void setCourseKind(Em_CourseKind::eCourseKind emCourseKind){m_emCourseKind = emCourseKind;}

private:
	
	PIDCtrl* m_pPIDCtrl;
	
	StandControl* m_pStandControl;
	
	TailControl* m_pTailControl;
	
	PositionControl* m_pPositionControl;
	
	VectorT<S32> m_cntEndPosition;
	
	S16 m_speed;
	

	int m_iXY;
	
	int m_isectionID;
	SonarSensor* m_pSoner;
	st_section m_sect;
	bool m_bDoObstaclesExist;
	
	int m_lCt;
	float m_TargetAngle;
	bool m_bRightTurn;
	long m_lMotorReset;
	Em_CourseKind::eCourseKind m_emCourseKind;
	Em_LookUpRunState::emLookUpRunState m_emLookUpRunState;
	Em_ETSumoRunState::emETSumoRunState m_emETSumoRunState;

};

#endif
