package com.yuji.ec;

import java.util.ArrayList;
import java.util.List;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;

import com.yuji.ec.common.Constant;
import com.yuji.ec.db.INoteItem;
import com.yuji.ec.db.NoteListItem;
import com.yuji.ec.task.NoteTypeListTask;
import com.yuji.ec.utility.AsyncTaskCommand;
import com.yuji.ec.utility.BaseActivity;
import com.yuji.ec.utility.EditPrefUtil;
import com.yuji.ec.utility.EvernoteUtil;
import com.yuji.ec.utility.EvernoteUtil.Error;

public class NoteTypeListActivity extends BaseActivity {
	private EditPrefUtil pref = new EditPrefUtil(this);

	private static List<NoteListItem> itemList = null;
	private LinearLayout layoutView = null;
	private TextView messageText = null;
	private ListView listView = null;
	private Button closeButon = null;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.note_type_list);

		layoutView = (LinearLayout) this.findViewById(R.id.noteTypeLayout);
		messageText = (TextView) this
				.findViewById(R.id.noteTypeConfirmDeleteMsg);
		listView = (ListView) this.findViewById(R.id.noteTypeView);
		closeButon = (Button) this.findViewById(R.id.noteTypeCloseButton);

		listView.setOnItemClickListener(new OnItemClickListener() {
			public void onItemClick(AdapterView<?> parent, View view,
					int position, long id) {
				listViewOnItemClickListener(parent, view, position, id);
			}
		});

		closeButon.setOnClickListener(new OnClickListener(){
			public void onClick(View v) {
				closeButonOnClick();
			}});
		closeButon.setEnabled(false);
		
		// updateList();
		if (itemList == null){
			int noteItemType = pref.getInt(Constant.PREF_NOTE_ITEM_TYPE_TMP,
					Constant.NOTE_ITEM_TYPE_ALL);
			NoteTypeListTask task = new NoteTypeListTask(this, noteItemType);
			AsyncTaskCommand command = new AsyncTaskCommand(this, task);
			command.setTitle(getString(R.string.noteTypeDialogTitle));
			command.setButtonTitle(getString(R.string.cancelButton));
			command.execute("");
		}
		else {
			setList(itemList);			
		}
		setStatus();
	}

	private void listViewOnItemClickListener(AdapterView<?> parent, View view,
			int position, long id) {
		ListView listView = (ListView) parent;

		NoteListItem selectedItem = (NoteListItem) listView
				.getItemAtPosition(position);
		INoteItem item = selectedItem.getItem();

		String guid = item.getGuid();
		String title = item.getText();

		Intent data = new Intent();
		data.putExtra(Constant.EXTRA_GUID, guid);
		data.putExtra(Constant.EXTRA_TITLE, title);
		setResult(RESULT_OK, data);
		finish();
	}

	private void closeButonOnClick(){
		finish();
	}
	
	public void done(Error errorCode, List<INoteItem> nList) {
		if (errorCode != null && !errorCode.equals(Error.NONE)) {
			EvernoteUtil util = EvernoteUtil.getInstance();
			Toast.makeText(this, util.getErrorMessage(this, errorCode),
					Toast.LENGTH_LONG).show();
		}

		if (nList == null) {
			finish();
			return;
		}

		List<NoteListItem> itemList = new ArrayList<NoteListItem>();
		for (INoteItem iItem : nList) {
			NoteListItem item = new NoteListItem(iItem.getText(), iItem);
			itemList.add(item);
		}
		
		setList(itemList);

		setStatus();
	}

	private void setList(List<NoteListItem> itemList) {
		NoteListViewArrayAdapter adapter = new NoteListViewArrayAdapter(this,
				R.layout.simple_list_item_1, itemList);
		listView.setAdapter(adapter);
		
		NoteTypeListActivity.itemList = itemList;
	}

	private void setStatus() {
		closeButon.setEnabled(itemList != null);
		layoutView.setVisibility(View.GONE);
	}
	
	public static void init(){
		itemList = null;
	}
}
