package com.yuji.ec.db;

import java.util.ArrayList;
import java.util.List;

import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;

import com.yuji.ec.utility.Debug;

public class NoteDao implements IDao<Note> {
	private static IDao<Note> instance = null;
	private SQLiteStatement insertStmt = null;
	private SQLiteStatement deleteStmt = null;

	public static IDao<Note> getInstance(){
		if (instance == null){
			instance = new NoteDao();
		}
		return instance;
	}	
	
	private NoteDao(){

	}
	
	public void onCreate(SQLiteDatabase db) {
		db.execSQL(
				"CREATE TABLE NOTE ("
				+ android.provider.BaseColumns._ID + " INTEGER PRIMARY KEY AUTOINCREMENT,"
				+ "GUID TEXT,"
				+ "TEXT TEXT,"
				+ "CREATED INTEGER,"
				+ "UPDATED INTEGER"
				+ ");");
	}
	
	public void init(SQLiteDatabase db) {
		insertStmt = db.compileStatement(
				"INSERT INTO NOTE ("
						+ "GUID,"
						+ "TEXT,"
						+ "CREATED,"
						+ "UPDATED"
				+ ") VALUES ("
				+ "?,?,?,?"
				+ ");");		
		deleteStmt = db.compileStatement(
				"DELETE FROM NOTE");
	}
	
	public void start(SQLiteDatabase db) {

	}

	public List<Note> search(){
		return search(null, null, null);
	}
	
	private List<Note> search(String selection, String[] selectionArgs, String orderBy){
		List<Note> list = new ArrayList<Note>();
		Cursor cursor = null;
		try {
			DatabaseHelper helper = DatabaseHelper.getInstance();
			SQLiteDatabase db = helper.getReadableDatabase();

			cursor = db.query(
					"NOTE",
					new String[] {
					android.provider.BaseColumns._ID, "GUID", "TEXT", "CREATED", "UPDATED"},
							selection, selectionArgs, null, null, orderBy);
			cursor.moveToFirst();
			int size = cursor.getCount();
			for (int i = 0; i < size; i++) {
				Note note = new Note(
						cursor.getLong(0),
						cursor.getString(1),
						cursor.getString(2),
						cursor.getLong(3),
						cursor.getLong(4));
				list.add(note);
			    cursor.moveToNext();
			}
		} catch (SQLException e){
			Debug.d(this, null, e);
			list = null;
		} catch (Exception e){
			Debug.d(this, null, e);
			list = null;
		}
		finally {
			if (cursor != null){
				cursor.close();	
				cursor = null;		
			}
		}
		return list;
	}

	public boolean isEmpty(){
		List<Note> list = search();
		return list == null || list.size() <= 0;
	}
	
	public void add(Note note) {
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();
		add(db, note);
	}
	
	private long add(SQLiteDatabase db, Note note) {
		long id = -1;
		db.beginTransaction();
		try {
			id = addNT(note);
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}
	
	public long addNT(Note note) {
		long id = -1;
		int i = 1;
		SQLiteStatement stmt = insertStmt;
		stmt.bindString(i++, note.getGuid());
		stmt.bindString(i++, note.getText());
		stmt.bindLong(i++, note.getCreated());
		stmt.bindLong(i++, note.getUpdated());
		id = stmt.executeInsert();
		return id;
	}

	public void deleteNT() {
		SQLiteStatement stmt = deleteStmt;
		stmt.execute();
	}
}
