package com.yuji.ec.task;

import java.lang.ref.WeakReference;
import java.util.List;

import com.evernote.edam.type.Notebook;
import com.evernote.edam.type.Tag;
import com.yuji.ec.NoteTypeListActivity;
import com.yuji.ec.common.Constant;
import com.yuji.ec.db.INoteItem;
import com.yuji.ec.utility.AsyncTaskIF;
import com.yuji.ec.utility.EvernoteUtil;

public class NoteTypeListTask implements AsyncTaskIF {
	private EvernoteUtil util = EvernoteUtil.getInstance();
	// private NoteList noteList;
	private WeakReference<NoteTypeListActivity> activityRef;
	private EvernoteUtil.Error errorCode = null;

	private List<INoteItem> list = null;
	private int noteItemType;

	public NoteTypeListTask(NoteTypeListActivity activity, int noteItemType) {
		activityRef = new WeakReference<NoteTypeListActivity>(activity);
		this.noteItemType = noteItemType;
	}

	public void doExecute() {
		synchronized (util) {
			try {
				EvernoteUtil util = EvernoteUtil.getInstance();
				switch (noteItemType) {
				case Constant.NOTE_ITEM_TYPE_NOTE_BOOK:
					List<Notebook> noteList = util.getNoteBookList();
					if (noteList != null) {
						list = util.toNoteItemFromNoteBook(noteList);
					}
					break;
				case Constant.NOTE_ITEM_TYPE_TAG:
					List<Tag> tagList = util.getTagList();
					if (tagList != null) {
						list = util.toNoteItemFromTag(tagList);
					}
					break;
				default:
					break;
				}
			} finally {
				errorCode = util.getErrorCode();
			}
		}
	}

	public void cancel() {

	}

	public void done(boolean isCancel) {
		NoteTypeListActivity activity = activityRef.get();
		if (activity != null) {
			activity.done(errorCode, list);
			activityRef = null;
		}
	}

	public int getStatus() {
		return 0;
	}

	// public NoteList getNoteList() {
	// return noteList;
	// }

	public EvernoteUtil.Error getErrorCode() {
		return errorCode;
	}
}
