package com.yuji.ec;

import java.util.List;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

import com.yuji.ec.db.NoteListItem;

public class NoteListViewArrayAdapter extends ArrayAdapter<NoteListItem> {
	private LayoutInflater inflater;

	public NoteListViewArrayAdapter(Context context, int resourceId,
			List<NoteListItem> items) {
		super(context, resourceId, items);
		inflater = (LayoutInflater) context
				.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		View view;
		TextView textView;
		NoteListItem item = getItem(position);
		if (item.getItem() != null) {
			view = inflater.inflate(R.layout.simple_list_item_1, null);
			textView = (TextView) view.findViewById(R.id.text1);
		} else {
			view = inflater.inflate(R.layout.small_list_item_1, null);
			textView = (TextView) view.findViewById(R.id.text2);
		}
		textView.setText(item.getTitle());

		return view;
	}

	@Override
	public boolean isEnabled(int position) {
		NoteListItem item = getItem(position);
		return item.getItem() != null;
	}
}
