package com.yuji.ef;

import android.app.Activity;
import android.content.Context;

import com.yuji.ef.common.Constant;
import com.yuji.ef.dao.BookDao;
import com.yuji.ef.dao.DatabaseHelper;
import com.yuji.ef.dao.LockDao;
import com.yuji.ef.dao.NodeCacheDao;
import com.yuji.ef.exception.EfError;
import com.yuji.ef.exception.EfException;
import com.yuji.ef.pref.EditPrefUtil;
import com.yuji.ef.service.NoteUpdatorService;
import com.yuji.ef.utility.Encryption;
import com.yuji.ef.utility.SdLog;

public class Initialize {
	private static Context context;
	private static boolean isInit = true;
	
	public static void initialize(Context applicatonContext, Activity activity) throws EfException {
		if (!isInit) {
			return;
		}

		try {
			context = applicatonContext;
			
			EditPrefUtil pref = new EditPrefUtil(context);
			pref.getInt(Constant.PREF_UPDATE_TIME, 0);
			pref.get(Constant.PREF_UPDATE_DATETIME, "");
			pref.getInt(Constant.PREF_DELETE_LOCK, 0);
			pref.getInt(Constant.PREF_UPDATE_DATA, Constant.OFF);
			pref.getLong(Constant.PREF_NEXT_TIME, 0L);
			pref.getLong(Constant.PREF_LOGIN_DATE, 0L);
			pref.update();
			
			DatabaseHelper.addDao(NodeCacheDao.getInstance());
			DatabaseHelper.addDao(BookDao.getInstance());
			DatabaseHelper.init(context, "EverFolder.db");
			DatabaseHelper.addDao(LockDao.getInstance());					
			DatabaseHelper.init(context, "Lock.db");
			
			// #29573
			if (activity != null && activity.getClass() == EverFolderActivity.class){
				pref.put(Constant.PREF_DELETE_LOCK, Constant.ON);
				pref.update();
			}
			
			NoteUpdatorService.init(context);
			
			isInit = false;
		} catch (Exception e) {
			SdLog.put(e);
			EfException.msg(R.string.ErrorSystem, e);
			throw new EfException(EfError.INIT);
		}
	}

	public static Context getContext() {
		return context;
	}
}
