package com.yuji.ef;

import java.util.List;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.TextView;

import com.evernote.client.oauth.android.EvernoteSession;
import com.yuji.ef.common.Constant;
import com.yuji.ef.dao.LockDao;
import com.yuji.ef.dao.Node;
import com.yuji.ef.dao.NodeCacheDao;
import com.yuji.ef.dao.NodeDao;
import com.yuji.ef.exception.EfException;
import com.yuji.ef.pref.EditPrefUtil;
import com.yuji.ef.service.NoteUpdatorService;
import com.yuji.ef.task.NoteUpdateTask;
import com.yuji.ef.utility.AsyncTaskCommand;
import com.yuji.ef.utility.BaseActivity;
import com.yuji.ef.utility.Debug;
import com.yuji.ef.utility.EvernoteUtil;
import com.yuji.ef.utility.LockHandler;
import com.yuji.ef.utility.LockListener;
import com.yuji.ef.utility.OAuthUtil;

public class SettingActivity extends BaseActivity implements LockListener {
	private EditPrefUtil pref = new EditPrefUtil(this);

	private LinearLayout msgLayout;
	private TextView confirmMsg;
	private Button loginButton;
	private Button logoutButton;
	private Button listButton;
	private Button bookButton;
	private Button updateButton;
	private Spinner updateSpinner;
	private LinearLayout updateDateLayout;
	private TextView updateDateText;
	private Button closeButton;

	private boolean isRegister = false;
	private boolean isBind = false;

	private boolean lock = false;
	private boolean isInit = true;
	private boolean isInCycle = false;
	private LockHandler lockHandler = null;
	
	private BroadcastReceiver broadcastReceiver = new BroadcastReceiver() {
		@Override
		public void onReceive(Context context, Intent intent) {
			String action = intent.getAction();

			if (action.equals(Constant.ACTION_MESSAGE)) {
				if (isInCycle){
					String msg = intent
							.getStringExtra(Constant.ACTION_MESSAGE_MESSAGE);
					EfException.msg(SettingActivity.this, msg);
				}
			} else if (action.equals(Constant.ACTION_UPDATE)) {
				if (isInCycle && !lock) {
					LockDao lockDao = (LockDao) LockDao.getInstance();
					lock = lockDao.lock(SettingActivity.this,
							Constant.LOCK_UPDATE_NOTE);
					setStatus();
				}
			}
		}
	};

	private class NoteUpdatorReceiver extends BroadcastReceiver {

		@Override
		public void onReceive(Context context, Intent intent) {
			;
		}
	}

	private NoteUpdatorService noteUpdatorService;
	private NoteUpdatorReceiver receiver = new NoteUpdatorReceiver();

	private ServiceConnection serviceConnection = new ServiceConnection() {
		public void onServiceConnected(ComponentName className, IBinder service) {
			noteUpdatorService = ((NoteUpdatorService.KitchenTimerBinder) service)
					.getService();
		}

		public void onServiceDisconnected(ComponentName className) {
			noteUpdatorService = null;
		}
	};

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.setting);

		IntentFilter intentFilter = new IntentFilter();
		intentFilter.addAction(Constant.ACTION_UPDATE);
		intentFilter.addAction(Constant.ACTION_MESSAGE);
		registerReceiver(broadcastReceiver, intentFilter);

		msgLayout = (LinearLayout) findViewById(R.id.settingMsgLayout);
		confirmMsg = (TextView) findViewById(R.id.settingConfirmMsg);
		loginButton = (Button) findViewById(R.id.settingLoginButton);
		logoutButton = (Button) findViewById(R.id.settingLogoutButton);
		listButton = (Button) findViewById(R.id.settingListButton);
		bookButton = (Button) findViewById(R.id.settingBookButton);
		updateButton = (Button) findViewById(R.id.settingUpdateButton);
		updateSpinner = (Spinner) findViewById(R.id.settingUpdateSpinner);
		updateDateLayout = (LinearLayout) findViewById(R.id.settingUpdateDateLayout);
		updateDateText = (TextView) findViewById(R.id.settingUpdateDateText);
		closeButton = (Button) findViewById(R.id.settingCloseButton);

		loginButton.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				loginButtonOnClick();
			}
		});
		logoutButton.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				logoutButtonOnClick();
			}
		});
		listButton.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				listButtonOnClick();
			}
		});
		bookButton.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				bookButtonOnClick();
			}
		});
		updateButton.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				updateButtonOnClick();
			}
		});
		closeButton.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				closeButtonOnClick();
			}
		});
		updateSpinner.setOnItemSelectedListener(new OnItemSelectedListener() {
			public void onItemSelected(AdapterView<?> parent, View view,
					int position, long id) {
				updateSpinnerItemSelected(parent, view, position, id);
			}

			public void onNothingSelected(AdapterView<?> view) {
				;
			}
		});

		ArrayAdapter<CharSequence> noteOrderAdapter = ArrayAdapter
				.createFromResource(this, R.array.note_update_time_array,
						android.R.layout.simple_spinner_item);
		noteOrderAdapter
				.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
		updateSpinner.setAdapter(noteOrderAdapter);

		OAuthUtil authUtil = OAuthUtil.getInstance();
		EvernoteSession session = authUtil.setupSession(this);
		EvernoteUtil.getInstance().setSession(session);
	}

	@Override
	public void sendLockResult(boolean b) {
		lock = true;

		if (isInit) {
			isInit = false;
		}
		setStatus();
	}

	@Override
	protected void onStart() {
		super.onStart();
	}

	@Override
	protected void onResume() {
		super.onResume();
		isInCycle = true;

		lockHandler = new LockHandler();
		boolean isUnlock = false;
		lockHandler.lock(this, Constant.LOCK_UPDATE_NOTE, true, isUnlock);
		lock = false;

		int updateTime = pref.getInt(Constant.PREF_UPDATE_TIME, 0);

		String[] values = getResources().getStringArray(
				R.array.note_update_time_array_value);
		for (int i = 0; i < values.length; i++) {
			if (updateTime <= Integer.parseInt(values[i])) {
				updateSpinner.setSelection(i);
				break;
			}
		}
		setStatus();
	}

	@Override
	protected void onPause() {
		int prevUpdateTime = pref.getInt(Constant.PREF_UPDATE_TIME, 0);
		String[] values = getResources().getStringArray(
				R.array.note_update_time_array_value);
		int pos = updateSpinner.getSelectedItemPosition();
		int updateTime = Integer.parseInt(values[pos]);

		if (prevUpdateTime != updateTime) {
			stopService();

			pref.put(Constant.PREF_UPDATE_TIME, updateTime);
			pref.update();
		}

		if (prevUpdateTime != updateTime) {
			if (updateTime > 0) {
				updateNote();
			}
		}

		// ロック未取得でも解除する(ゴミ掃除)
		LockDao lockDao = (LockDao) LockDao.getInstance();
		lockDao.unlock(this, Constant.LOCK_UPDATE_NOTE);
		lock = false;

		if (lockHandler != null){
			lockHandler.cancel();
			lockHandler = null;
		}
		
		super.onPause();
		isInCycle = false;
	}

	@Override
	protected void onDestroy(){
		if (isBind) {
			unbindService(serviceConnection); // バインド解除
			isBind = false;
		}
		serviceConnection = null;

		if (isRegister) {
			unregisterReceiver(receiver); // 登録解除
			isRegister = false;
		}
		receiver = null;

		if (broadcastReceiver != null){
			// 必ずonDestroy()が呼ばれるとは限らないが、仕方なく
			unregisterReceiver(broadcastReceiver);
			broadcastReceiver = null;
		}
		super.onDestroy();
	}
	
	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		isInit = true;
	}

	private void stopService() {
		NoteUpdatorService.stopService(this);
	}

	private void updateNote() {
		try {
			stopService();

			Intent intent = new Intent(this, NoteUpdatorService.class);
			intent.setAction(NoteUpdatorService.ACTION_START);
			startService(intent);
			IntentFilter filter = new IntentFilter(NoteUpdatorService.ACTION);
			registerReceiver(receiver, filter);
			isRegister = true;

			// サービスにバインド
			bindService(intent, serviceConnection, Context.BIND_AUTO_CREATE);
			isBind = true;
		} catch (Exception e) {
			Debug.d(this, null, e);
		}
	}

	private void loginButtonOnClick() {
		Intent intent = new Intent(this, (Class<?>) OAuthActivity.class);
		startActivityForResult(intent, 0);
	}
	
	private void logoutButtonOnClick(){
		try {
			OAuthUtil util = OAuthUtil.getInstance();
			util.logout(this);
			EvernoteSession session = util.setupSession(this);
			EvernoteUtil.getInstance().setSession(session);
			
			setStatus();
		}
		catch (Exception e){
			EfException.msg(R.string.ErrorSystem, e);
		}
	}

	private void listButtonOnClick() {
		updateButton(false);
	}

	private void bookButtonOnClick() {
		Intent intent = new Intent(this, (Class<?>) BookListActivity.class);
		startActivityForResult(intent, 0);
	}

	private void updateButtonOnClick() {
		updateButton(true);
	}

	private void updateButton(boolean isAll) {
		// #29618
		// LockDao lockDao = (LockDao) LockDao.getInstance();
		// lock = lockDao.lock(this, Constant.LOCK_UPDATE_NOTE);
		LockDao lockDao = (LockDao) LockDao.getInstance();
		boolean b = lockDao.move(NoteUpdateTask.LOCK_OBJ,
				Constant.LOCK_UPDATE_NOTE);
		if (!b) {
			EfException.msg(R.string.ErrorSystem);
			return;
		}

		if (!lock) {
			setStatus();
			return;
		}

		pref.put(Constant.PREF_UPDATE_DATA, Constant.ON);
		pref.update();

		lock = false;
		setStatus();

		NoteUpdateTask task = new NoteUpdateTask(this, true, true, isAll, true);

		AsyncTaskCommand command = new AsyncTaskCommand(this, task);
		// command.setTitle(getString(R.string.updatorNoteDialogTitle));
		// command.setButtonTitle(getString(R.string.cancelButton));
		command.setCancelable(false);
		command.setDialog(false);
		command.execute("");
	}

	public void done(int errorCode) {
		// // #29618
		// // lock = false;
		// lock = true;
		//
		// setStatus();

		if (isInCycle) {
			// onResume()で生成している & cancel()は、呼ばれていないため
			//lockHandler = new LockHandler();
			boolean isUnlock = false;
			lockHandler.lock(this, Constant.LOCK_UPDATE_NOTE, true, isUnlock);
			lock = false;
			setStatus();
		}
	}

	private void updateSpinnerItemSelected(AdapterView<?> parent, View view,
			int position, long id) {
		setStatus();
	}

	private void closeButtonOnClick() {
		finish();
	}

	private void setStatus() {
		if (!lock) {
			msgLayout.setVisibility(View.VISIBLE);
			confirmMsg.setText(getString(R.string.settingUpdateMsg));

			loginButton.setEnabled(false);
			logoutButton.setEnabled(false);
			listButton.setEnabled(false);
			bookButton.setEnabled(false);
			updateButton.setEnabled(false);
			updateSpinner.setEnabled(false);
			updateDateLayout.setVisibility(View.GONE);

			return;
		}

		EvernoteUtil util = EvernoteUtil.getInstance();
		if (!util.isLoggedIn()) {
			msgLayout.setVisibility(View.VISIBLE);
			confirmMsg.setText(getString(R.string.settingLoginMsg));

			loginButton.setEnabled(true);
			logoutButton.setEnabled(false);
			listButton.setEnabled(false);
			listButton.setVisibility(View.GONE);
			bookButton.setEnabled(false);
			updateButton.setEnabled(false);
			updateSpinner.setEnabled(false);
			updateDateLayout.setVisibility(View.GONE);

			return;
		}

		NodeDao dao = (NodeDao) NodeCacheDao.getInstance();
		List<Node> list = dao.searchBook();
		if (list == null || list.size() <= 0) {
			msgLayout.setVisibility(View.VISIBLE);
			confirmMsg.setText(getString(R.string.settingDoListMsg));

			loginButton.setEnabled(false);
			logoutButton.setEnabled(true);
			listButton.setEnabled(true);
			listButton.setVisibility(View.VISIBLE);
			bookButton.setEnabled(false);
			updateButton.setEnabled(false);
			updateSpinner.setEnabled(false);
			updateDateLayout.setVisibility(View.GONE);

			return;
		}

		list = dao.searchSelectedBook();
		if (list == null || list.size() <= 0) {
			msgLayout.setVisibility(View.VISIBLE);
			confirmMsg.setText(getString(R.string.settingDoSelectMsg));

			loginButton.setEnabled(false);
			logoutButton.setEnabled(true);
			listButton.setEnabled(false);
			listButton.setVisibility(View.GONE);
			bookButton.setEnabled(true);
			updateButton.setEnabled(false);
			updateSpinner.setEnabled(false);
			updateDateLayout.setVisibility(View.GONE);

			return;
		}

		if (dao.isEmptyNote()) {
			msgLayout.setVisibility(View.VISIBLE);
			confirmMsg.setText(getString(R.string.settingDoUpdateMsg));

			loginButton.setEnabled(false);
			logoutButton.setEnabled(true);
			listButton.setEnabled(false);
			listButton.setVisibility(View.GONE);
			bookButton.setEnabled(true);
			updateButton.setEnabled(true);
			updateSpinner.setEnabled(false);
			updateDateLayout.setVisibility(View.GONE);
			return;
		}

		loginButton.setEnabled(false);
		logoutButton.setEnabled(true);
		listButton.setEnabled(false);
		listButton.setVisibility(View.GONE);
		bookButton.setEnabled(true);
		updateButton.setEnabled(true);
		updateSpinner.setEnabled(true);

		int pos = updateSpinner.getSelectedItemPosition();
		if (pos == 0) {
			updateDateLayout.setVisibility(View.GONE);
		} else {
			updateDateLayout.setVisibility(View.VISIBLE);
		}
		String updateDate = pref.get(Constant.PREF_UPDATE_DATETIME);
		updateDateText.setText(updateDate);

		msgLayout.setVisibility(View.GONE);
	}

}
