package com.yuji.ef.dao;

import java.util.ArrayList;
import java.util.List;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

import com.yuji.ef.utility.Debug;

public class DatabaseHelper extends SQLiteOpenHelper {
	private static List<DatabaseHelper> instances = new ArrayList<DatabaseHelper>();
	private static List<List<IDao<?>>> daoLists = new ArrayList<List<IDao<?>>>();
	private int id;
	
	public static DatabaseHelper getInstance() {
		return getInstance(0);
	}

	public static DatabaseHelper getInstance(int id) {
		return instances.get(id);
	}

	public static void addDao(IDao<?> dao){
		int id = instances.size();
		while (daoLists.size() < id + 1){
			daoLists.add(new ArrayList<IDao<?>>());
		}
		List<IDao<?>> daoList = daoLists.get(id);
		daoList.add(dao);
	}
	
	public static void init(Context context, String name) {
		int id = instances.size();
		DatabaseHelper helper = new DatabaseHelper(context, name, id);
		SQLiteDatabase db = helper.getWritableDatabase();
		instances.add(helper);

		List<IDao<?>> daoList = daoLists.get(id);
		for (IDao<?> dao : daoList) {
			dao.init(db);
		}
	}

	private DatabaseHelper(Context context, String name, int id) {
//		super(context, "EverFolder.db", null, 1);
		super(context, name, null, 1);
		this.id = id;
	}

	@Override
	public void onCreate(SQLiteDatabase db) {
		try {
			List<IDao<?>> daoList = daoLists.get(id);
			
			for (IDao<?> dao : daoList) {
				dao.onCreate(db);
				dao.init(db);
			}

			db.beginTransaction();
			try {
				for (IDao<?> dao : daoList) {
					dao.start(db);
				}
				db.setTransactionSuccessful();
			} finally {
				db.endTransaction();
			}
		} catch (Exception e) {
			Debug.d(this, null, e);
		}
	}

	@Override
	public void onUpgrade(SQLiteDatabase arg0, int arg1, int arg2) {

	}

	public SQLiteDatabase getSQLiteDatabase() {
		DatabaseHelper helper = DatabaseHelper.getInstance(id);
		SQLiteDatabase db = helper.getWritableDatabase();
		return db;
	}	
}
