package com.yuji.ef.dao;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteConstraintException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;

import com.yuji.ef.utility.Debug;

public class LockDao implements IDao<Lock> {
	private static final int DEFAULT_PERIOD = 60 * 60; // 1時間

	private static IDao<Lock> instance = null;
	private SQLiteStatement insertStmt = null;
	private SQLiteStatement updateStmt = null;
	private SQLiteStatement deleteIdStmt = null;
	private SQLiteStatement deleteUpdatedStmt = null;

	public static IDao<Lock> getInstance() {
		if (instance == null) {
			instance = new LockDao();
		}
		return instance;
	}

	@Override
	public void onCreate(SQLiteDatabase db) {
		db.execSQL("CREATE TABLE LOCK (" + android.provider.BaseColumns._ID
				+ " INTEGER PRIMARY KEY AUTOINCREMENT," + "KEY TEXT,"
				+ "CLASS TEXT," + "STATUS INTEGER," + "UPDATED INTEGER,"
				+ "UNIQUE(KEY)" + ");");
	}

	@Override
	public void init(SQLiteDatabase db) {
		insertStmt = db.compileStatement("INSERT INTO LOCK (" + "KEY,"
				+ "CLASS," + "STATUS," + "UPDATED" + ") VALUES (" + "?,?,?,?"
				+ ");");
		updateStmt = db
				.compileStatement("UPDATE LOCK SET CLASS = ? WHERE KEY = ?");
		deleteIdStmt = db.compileStatement("DELETE FROM LOCK WHERE "
				+ "KEY = ? AND CLASS = ?");
		deleteUpdatedStmt = db.compileStatement("DELETE FROM LOCK WHERE "
				+ "KEY = ? AND UPDATED < ?");

	}

	@Override
	public void start(SQLiteDatabase db) {

	}

	@Override
	public List<Lock> search() {
		return search(null, null, null);
	}

	public List<Lock> search(SQLiteDatabase db) {
		return search(db, null, null, null);
	}

	public Lock searchByKey(String key) {
		String selection = "KEY = ?";
		String[] selectionArgs = { key };
		String orderBy = null;
		List<Lock> list = search(selection, selectionArgs, orderBy);
		if (list.size() <= 0) {
			return null;
		}
		return list.get(0);
	}

	private List<Lock> search(String selection, String[] selectionArgs,
			String orderBy) {
		return search(getSQLiteDatabase(), selection, selectionArgs, orderBy);
	}

	private List<Lock> search(SQLiteDatabase db, String selection,
			String[] selectionArgs, String orderBy) {
		List<Lock> list = new ArrayList<Lock>();
		Cursor cursor = null;
		try {
			cursor = db.query("LOCK", new String[] {
					android.provider.BaseColumns._ID, "KEY", "CLASS", "STATUS",
					"UPDATED" }, selection, selectionArgs, null, null, orderBy);
			cursor.moveToFirst();
			int size = cursor.getCount();
			for (int i = 0; i < size; i++) {
				int index = 0;
				Lock lock = new Lock();
				lock.setId(cursor.getLong(index++));
				lock.setKey(cursor.getString(index++));
				lock.setClazz(cursor.getString(index++));
				lock.setStatus(cursor.getInt(index++));
				lock.setUpdated(cursor.getShort(index++));
				list.add(lock);
				cursor.moveToNext();
			}
		} catch (SQLException e) {
			Debug.d(this, null, e);
			list = null;
		} catch (Exception e) {
			Debug.d(this, null, e);
			list = null;
		} finally {
			if (cursor != null) {
				cursor.close();
				cursor = null;
			}
		}
		return list;
	}

	public long add(Lock lock) {
		return add(getSQLiteDatabase(), lock);
	}

	private long add(SQLiteDatabase db, Lock lock) {
		long id = -1;
		db.beginTransaction();
		try {
			Calendar cal = Calendar.getInstance();
			long updated = cal.getTimeInMillis();
			updated -= DEFAULT_PERIOD * 1000;

			deleteUpdatedNT(lock.getKey(), updated);
			deleteNT(lock.getKey(), lock.getClazz());
			id = addNT(lock);
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	public long addNT(Lock lock) {
		long id = -1;
		int i = 1;
		try {
			SQLiteStatement stmt = insertStmt;
			stmt.bindString(i++, lock.getKey());
			stmt.bindString(i++, lock.getClazz());
			stmt.bindLong(i++, lock.getStatus());
			stmt.bindLong(i++, lock.getUpdated());
			id = stmt.executeInsert();
		} catch (SQLiteConstraintException e) {
			// error code 19: constraint failed
			List<Lock> list = this.search();
			for (Lock l : list) {
				Debug.d(this, l.toString());
			}

			id = 0;
		}
		return id;
	}

	public long update(Lock lock, String clazz) {
		return update(getSQLiteDatabase(), lock, clazz);
	}

	private long update(SQLiteDatabase db, Lock lock, String clazz) {
		long id = -1;
		db.beginTransaction();
		try {
			id = updateNT(lock, clazz);
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	public long updateNT(Lock lock, String clazz) {
		long id = -1;
		int i = 1;

		SQLiteStatement stmt = updateStmt;
		stmt.bindString(i++, clazz);
		stmt.bindString(i++, lock.getKey());
		id = stmt.executeInsert();
		return id;
	}

	public long delete(String key, String clazz) {
		return delete(getSQLiteDatabase(), key, clazz);
	}

	public long delete(SQLiteDatabase db, String key, String clazz) {
		long id = -1;

		db.beginTransaction();
		try {
			id = deleteNT(key, clazz);
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	public long deleteNT(String key, String clazz) {
		long id = -1;
		int i = 1;

		SQLiteStatement stmt = deleteIdStmt;
		stmt.bindString(i++, key);
		stmt.bindString(i++, clazz);
		stmt.execute();
		return id;
	}

	public long deleteUpdatedNT(String key, long updated) {
		long id = -1;
		int i = 1;

		SQLiteStatement stmt = deleteUpdatedStmt;
		stmt.bindString(i++, key);
		stmt.bindLong(i++, updated);
		stmt.execute();
		return id;
	}

	private String getClazz(Object obj) {
		return obj.getClass().getName();
	}

	public boolean lock(Object obj, String key) {
		Calendar cal = Calendar.getInstance();
		long updated = cal.getTimeInMillis();

		Lock lock = new Lock();
		lock.setKey(key);
		lock.setClazz(getClazz(obj));
		lock.setUpdated(updated);
		if (this.add(lock) > 0) {
			lockInfo = "<none>";
			return true;
		} else {
			List<Lock> list = this.search();
			if (list.size() > 0) {
				try {
					lock = list.get(0);
					String c = lock.getClazz();
					String s = lock.getKey();
					Debug.d(this, c + "," + s);
					lockInfo = c + "," + s;
				} catch (Exception e) {
					;
				}
			}
			return false;
		}
	}

	public boolean move(Object obj, String key) {

		Lock lock = new Lock();
		lock.setKey(key);

		return update(lock, getClazz(obj)) > 0;
	}

	public void unlock(Class<?> clazz, String key) {
		try {
			this.delete(key, clazz.getName());
		} catch (Exception e) {
			;
		}
	}

	public void unlock(Object obj, String key) {
		try {
			this.delete(key, getClazz(obj));
		} catch (Exception e) {
			;
		}
	}

	public boolean isLock(Object obj, String key) {
		return searchByKey(key) != null;
	}

	public SQLiteDatabase getSQLiteDatabase() {
		return DatabaseHelper.getInstance(1).getSQLiteDatabase();
	}

	// for DEBUG
	private String lockInfo = "<none>";

	public String getLockInfo() {
		return lockInfo;
	}
}
