package com.yuji.ef.dao;

import java.util.LinkedHashMap;
import java.util.Map;

import android.database.sqlite.SQLiteDatabase;

import com.yuji.ef.dao.Node.Status;

public class NodeCacheDao extends NodeDaoImpl implements IDao<Node>, NodeDao {
	private static final int MAP_SIZE = 1024;

	private static IDao<Node> instance = null;
	private static LinkedHashMap<Long, Node> map = new LinkedHashMap<Long, Node>(
			MAP_SIZE, (float) 0.75, true) {
		@Override
		protected boolean removeEldestEntry(Map.Entry eldest) {
			return size() > MAP_SIZE;
		}
	};

	public static IDao<Node> getInstance() {
		if (instance == null) {
			instance = new NodeCacheDao();
		}
		return instance;
	}

	private NodeCacheDao() {

	}

	@Override
	public Node searchById(SQLiteDatabase db, long id) {
		Node n = map.get(id);
		if (n != null) {
			return n;
		}
		n = super.searchById(db, id);
		map.put(id, n);
		return n;
	}

	@Override
	public long updateChildrenNT(Node node, String children) {
		map.remove(node.getId());
		return super.updateChildrenNT(node, children);
	}

	@Override
	public long removeChildrenIdNT(Node node, long id) {
		map.remove(node.getId());
		return super.removeChildrenIdNT(node, id);
	}

	@Override
	public long updateStatusNT(Node node, Status status) {
		map.remove(node.getId());
		return super.updateStatusNT(node, status);
	}

	@Override
	public long updateNameNT(Node node, String name) {
		map.remove(node.getId());
		return super.updateNameNT(node, name);
	}

	@Override
	public long updateSelectedNT(Node node, boolean isSelected) {
		map.remove(node.getId());
		return super.updateSelectedNT(node, isSelected);
	}
	
	@Override
	public long updateGuidNT(Node node, String guid) {
		map.remove(node.getId());
		return super.updateGuidNT(node, guid);
	}

	@Override
	public long updateParentNT(Node node, long parent) {
		map.remove(node.getId());
		return super.updateParentNT(node, parent);
	}

	@Override
	public long deleteNT(long did) {
		map.remove(did);
		return super.deleteNT(did);
	}

	@Override
	public void deleteNT() {
		map.clear();
		super.deleteNT();
	}

	@Override
	public void clear() {
		map.clear();		
	}
}
