package com.yuji.ef;

import android.content.Context;

import com.yuji.ef.common.Constant;
import com.yuji.ef.dao.DatabaseHelper;
import com.yuji.ef.pref.EditPrefUtil;
import com.yuji.ef.service.NoteUpdatorService;
import com.yuji.ef.utility.EvernoteUtil;

public class Initialize {
	private static boolean isInit = true;

	public static void initialize(Context context) {
		if (!isInit) {
			return;
		}

		try {
			EditPrefUtil pref = new EditPrefUtil(context);
			pref.getInt(Constant.PREF_UPDATE_TIME, 0);
			pref.update();
			
			EvernoteUtil util = EvernoteUtil.getInstance();
			util.setConfig("yuji-k64613", "TODO");
			DatabaseHelper.init(context);
			
			NoteUpdatorService.init(context);
		} catch (Exception e) {
			// TODO
			e.printStackTrace();
		}
		isInit = false;
	}
}
