package com.yuji.ef.service;

import java.util.Calendar;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.widget.Toast;

import com.yuji.ef.Initialize;
import com.yuji.ef.common.Constant;
import com.yuji.ef.dao.LockDao;
import com.yuji.ef.pref.EditPrefUtil;
import com.yuji.ef.task.NoteUpdateTask;
import com.yuji.ef.utility.DateUtil;
import com.yuji.ef.utility.Debug;
import com.yuji.ef.utility.EvernoteUtil;
import com.yuji.ef.utility.NetworkUtil;

public class NoteUpdatorService extends Service {
	private static final boolean DEBUG = false;

	public class KitchenTimerBinder extends Binder {
		public NoteUpdatorService getService() {
			return NoteUpdatorService.this;
		}
	}

	public static final String ACTION = "NoteUpdatorService";
	public static final String ACTION_START = "START";
	private static final int DS = 60;
	private EditPrefUtil pref = new EditPrefUtil(this);
	private KitchenTimerBinder binder = new KitchenTimerBinder();
	private String action = null;

	@Override
	public void onCreate() {
		super.onCreate();

		if (DEBUG) {
			Toast toast = Toast.makeText(getApplicationContext(), "onCreate()",
					Toast.LENGTH_SHORT);
			toast.show();
		}
	}

	private Runnable task = new Runnable() {
		public void run() {
			try {
				if (action.equals(ACTION_START)) {
					// 初期起動
				} else {
					// タイマー起動
					synchronized (binder) {
						LockDao dao = (LockDao) LockDao.getInstance();
						try {
							if (!NetworkUtil
									.isConnected(NoteUpdatorService.this)) {
								return;
							}
							EvernoteUtil util = EvernoteUtil.getInstance();
							if (!util.isLoggedIn()) {
								return;
							}
							boolean b = dao.lock(NoteUpdatorService.this,
									Constant.LOCK_UPDATE_NOTE);
							if (b) {
								execute();
							}
						} catch (Exception e) {
							Debug.d(this, null, e);
						} finally {
							// ロック未取得でも解除する(ゴミ掃除)
							dao.unlock(NoteUpdatorService.this,
									Constant.LOCK_UPDATE_NOTE);

							Intent intent = new Intent(Constant.ACTION_UPDATE);
							sendBroadcast(intent);
						}
					}
				}

				setNextTime(NoteUpdatorService.this);
			} finally {
				NoteUpdatorService.this.stopSelf();
			}
		}

		private void execute() {
			Initialize.initialize(NoteUpdatorService.this);

			NoteUpdateTask task = new NoteUpdateTask(null, true, true, true);
			task.doExecute();
		}
	};

	@Override
	public void onStart(Intent intent, int startId) {
		super.onStart(intent, startId);

		action = intent.getAction();
		action = (action == null) ? "" : action;

		if (DEBUG) {
			Toast toast = Toast.makeText(getApplicationContext(), "onStart() "
					+ action + " " + startId, Toast.LENGTH_SHORT);
			toast.show();
		}

		Thread thread = new Thread(null, task, "AlarmService_Service");
		thread.start();
	}

	@Override
	public void onDestroy() {
		super.onDestroy();

		if (DEBUG) {
			Toast toast = Toast.makeText(getApplicationContext(),
					"onDestroy()", Toast.LENGTH_SHORT);
			toast.show();
		}
	}

	@Override
	public IBinder onBind(Intent intent) {
		if (DEBUG) {
			Toast toast = Toast.makeText(getApplicationContext(), "onBind()",
					Toast.LENGTH_SHORT);
			toast.show();
		}

		return binder;
	}

	@Override
	public void onRebind(Intent intent) {
		if (DEBUG) {
			Toast toast = Toast.makeText(getApplicationContext(), "onRebind()",
					Toast.LENGTH_SHORT);
			toast.show();
		}
	}

	@Override
	public boolean onUnbind(Intent intent) {
		if (DEBUG) {
			Toast toast = Toast.makeText(getApplicationContext(), "onUnbind()",
					Toast.LENGTH_SHORT);
			toast.show();
		}
		return true;
	}

	public static void setNextTime(Context context) {
		EditPrefUtil pref = new EditPrefUtil(context);

		long updateTime = pref.getLong(Constant.PREF_UPDATE_TIME);
		if (updateTime <= 0) {
			return;
		}

		Calendar cal = Calendar.getInstance();
		// cal.add(Calendar.HOUR, (int) updateTime);
		cal.add(Calendar.MINUTE, (int) updateTime); // TODO

		long t = cal.getTimeInMillis();
		PendingIntent alarmSender = PendingIntent.getService(context, 0,
				new Intent(context, NoteUpdatorService.class), 0);
		AlarmManager am = (AlarmManager) context
				.getSystemService(Context.ALARM_SERVICE);
		am.set(AlarmManager.RTC, t, alarmSender);
	}

	public static void stopService(Context context) {
		PendingIntent alarmSender = PendingIntent.getService(context, 0,
				new Intent(context, NoteUpdatorService.class),
				PendingIntent.FLAG_CANCEL_CURRENT);
	}

	public static boolean isSetAlarmSender(Context context) {
		PendingIntent alarmSender = PendingIntent.getService(context, 0,
				new Intent(context, NoteUpdatorService.class),
				PendingIntent.FLAG_NO_CREATE);
		return alarmSender != null;
	}

	public static void init(Context context) {
		EditPrefUtil pref = new EditPrefUtil(context);

		boolean isSet = NoteUpdatorService.isSetAlarmSender(context);
		int updateTime = pref.getInt(Constant.PREF_UPDATE_TIME);

		if (updateTime > 0) {
			if (!isSet) {
				// 再起動時
				setNextTime(context);
			}
		} else {
			if (isSet) {
				// データ削除時
				// isSetはクリアされないが、問題ないので毎回よぶ
				stopService(context);
			}
		}
	}
}