﻿/*
 * Created by SharpDevelop.
 * User: banana
 * Date: 2013/10/07
 * Time: 9:30
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using EWatch.Models;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace EWatch.Utils
{
	/// <summary>
	/// Description of JsonUtil.
	/// </summary>
	public class JsonUtil
	{
		public static object Parse(string json)
		{
			return JObject.Parse(json);
		}
		
		public static bool IsDefined(object jsonObject, string name)
		{
			if(jsonObject.GetType() == typeof(JObject)){
				JObject js = (JObject)jsonObject;
				return js[name] != null;
			}
			return false;
		}
		
		public static string GetString(object jsonObject, string name)
		{
			if(jsonObject.GetType() == typeof(JObject)){
				JObject js = (JObject)jsonObject;
				return (string)js[name];
			}
			return null;
		}
		
		public static int? GetInt(object jsonObject, string name)
		{
			if(jsonObject.GetType() == typeof(JObject)){
				JObject js = (JObject)jsonObject;
				object value = js[name];
				if(value != null){
					return (int)value;
				}
			}
			return null;
		}
		
		public static double? GetDouble(object jsonObject, string name)
		{
			if(jsonObject.GetType() == typeof(JObject)){
				JObject js = (JObject)jsonObject;
				object value = js[name];
				if(value != null){
					return (double)value;
				}
			}
			return null;
		}
		
		public static DateTime? GetDateTime(object jsonObject, string name)
		{
			if(jsonObject.GetType() == typeof(JObject)){
				JObject js = (JObject)jsonObject;
				object value = js[name];
				if(value != null){
					return (DateTime)value;
				}
			}
			return null;
		}
		
		public static object GetObject(object jsonObject, string name)
		{
			if(jsonObject.GetType() == typeof(JObject)){
				JObject js = (JObject)jsonObject;
				return js[name];
			}
			return null;
		}
		
		public static object GetObject(object jsonObject, int index)
		{
			if(jsonObject.GetType() == typeof(JArray)){
				JArray ja = (JArray)jsonObject;
				return ja[index];
			}
			return null;
		}
		
		public static object GetArray(object jsonObject, string name)
		{
			if(jsonObject.GetType() == typeof(JObject)){
				JObject js = (JObject)jsonObject;
				return (JArray)js[name];
			}
			return null;
		}
		
		public static object GetArray(object jsonObject, int index)
		{
			if(jsonObject.GetType() == typeof(JArray)){
				JArray ja = (JArray)jsonObject;
				return (JArray)ja[index];
			}
			return null;
		}
		
		public static int GetCount(object jsonObject)
		{
			if(jsonObject.GetType() == typeof(JArray)){
				JArray ja = (JArray)jsonObject;
				return ja.Count;
			}
			return 0;
		}
		
		public static ICollection<string> GetPropertyNames(object jsonObject)
		{
			List<string> result = new List<string>();
			if(jsonObject.GetType() == typeof(JObject)){
				JObject js = (JObject)jsonObject;
				foreach(JProperty p in js.Properties()){
					result.Add(p.Name);
				}
			}
			return result;
		}
		
		public static string ObjectToString(object obj)
		{
			return JObject.FromObject(obj).ToString(Formatting.None);
		}
		
		public static object StringToObject(string json, Type type)
		{
			return JsonConvert.DeserializeObject(json, type);
		}
		
		public static bool IsComment(object jsonObject)
		{
			if(jsonObject is JToken){
				return ((JToken)jsonObject).Type == JTokenType.Comment;
			}
			return false;
		}
	}
}
