﻿/*
 * Created by SharpDevelop.
 * User: banana
 * Date: 2013/10/07
 * Time: 15:09
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Diagnostics.Eventing.Reader;
using EWatch.Models;
using EWatch.Models.Configurations;

namespace EWatch.Watchers
{
	/// <summary>
	/// Description of EventLogWatcher.
	/// </summary>
	public class EventLogWatcher : BaseWatcher
	{
		private string name;
		private EventLog eventLog;

		public EventLogWatcher(string name, List<ActionTable> actionTable) : base(actionTable)
		{
			this.name = name;
			eventLog = new EventLog(name);
			eventLog.EntryWritten += new EntryWrittenEventHandler(EntryWritten);
			eventLog.EnableRaisingEvents = true;
		}
		
		public override void Watch()
		{
		}
		
		public override void Dispose()
		{
		}
		
		private void EntryWritten(object sender, EntryWrittenEventArgs e)
		{
			string level = null;
			switch(e.Entry.EntryType){
				case EventLogEntryType.Error:
				case EventLogEntryType.FailureAudit:
					level = "E";
					break;
				case EventLogEntryType.Warning:
					level = "W";
					break;
				case EventLogEntryType.Information:
					level = "I";
					break;
			}
			FindAndExecute(new LogData {
			               	Code = (int)e.Entry.InstanceId,
			               	HostName = e.Entry.MachineName,
			               	Source = e.Entry.Source,
			               	Level = level,
			               	TimeStamp = e.Entry.TimeGenerated,
			               	Message = e.Entry.Message
			               });
		}
	}
}
