﻿/*
 * Created by SharpDevelop.
 * User: banana
 * Date: 2013/10/07
 * Time: 14:45
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using EWatch.Models.Configurations;

namespace EWatch.Watchers
{
	/// <summary>
	/// Description of WatchThread.
	/// </summary>
	public class WatchThread
	{
		private Configuration config;
		private bool stopRunning = false;
		private bool suspend = false;
		private AutoResetEvent autoResetEvent;
		private List<BaseWatcher> watchers;
		
		public WatchThread(Configuration config)
		{
			this.config = config;
			autoResetEvent = new AutoResetEvent(true);
		}
		
		public void Start()
		{
			CreateWatchers();
			stopRunning = false;
			suspend = false;
			while(!stopRunning){
				if(suspend){
					autoResetEvent.WaitOne();
				}
				foreach(BaseWatcher watcher in watchers){
					watcher.Watch();
				}
				Thread.Sleep(1000);
			}
			foreach(BaseWatcher watcher in watchers){
				try {
					watcher.Dispose();
				}
				catch(Exception){
				}
			}
		}
		
		public void Stop()
		{
			stopRunning = true;
		}
		
		public void Suspend()
		{
			autoResetEvent.Reset();
			suspend = true;
		}
		
		public void Resume()
		{
			autoResetEvent.Set();
			suspend = false;
		}
		
		private void CreateWatchers()
		{
			watchers = new List<BaseWatcher>();
			Dictionary<string,List<ActionTable>> eventlogs = config.EventLog;
			foreach(string name in eventlogs.Keys){
				BaseWatcher watcher = new EventLogWatcher(name, eventlogs[name]);
				watchers.Add(watcher);
			}
			Dictionary<string,List<ActionTable>> files = config.File;
			foreach(string path in files.Keys){
				BaseWatcher watcher = new FileWatcher(path, Encoding.UTF8, files[path]);
				watchers.Add(watcher);
			}
			Dictionary<string,List<ActionTable>> syslogs = config.Syslog;
			foreach(string port in syslogs.Keys){
				BaseWatcher watcher = new SyslogServer(port, syslogs[port]);
				watchers.Add(watcher);
			}
		}
	}
}
