﻿/*
 * Created by SharpDevelop.
 * User: banana
 * Date: 2013/10/17
 * Time: 10:17
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using EWatch.Actions;
using EWatch.Utils;

namespace EWatchUI
{
	/// <summary>
	/// Description of ActionMantisEditControl.
	/// </summary>
	public partial class ActionMantisEditControl : UserControl
	{
		public ActionMantisEditControl()
		{
			//
			// The InitializeComponent() call is required for Windows Forms designer support.
			//
			InitializeComponent();
			
			//
			// TODO: Add constructor code after the InitializeComponent() call.
			//
		}
		
		public void SetData(ActionMantis action)
		{
			textBoxUrl.Text = action.BaseUrl;
			textBoxProject.Text = action.Project;
			textBoxUserId.Text = action.UserID;
			textBoxPassword.Text = action.Password;
		}
		
		public ActionMantis GetData()
		{
			string url = textBoxUrl.Text;
			if(!Util.IsNullOrEmpty(url)){
				if(!url.EndsWith("/")){
					url += "/";
				}
			}
			return new ActionMantis {
				BaseUrl = url,
				Project = textBoxProject.Text,
				UserID = textBoxUserId.Text,
				Password = textBoxPassword.Text,
			};
		}
	}
}
