﻿/*
 * Created by SharpDevelop.
 * User: banana
 * Date: 2013/10/15
 * Time: 12:04
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Collections.Generic;
using System.IO;
using EWatch;
using EWatch.Actions;
using EWatch.Models.Configurations;
using EWatch.Utils;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace EWatchUI.Controls
{
	/// <summary>
	/// Description of SaveConfig.
	/// </summary>
	public class SaveConfig : BaseControl
	{
		public Configuration Config { get; set; }
		
		public SaveConfig()
		{
		}
		
		public override object Execute()
		{
			try {
				JObject obj = new JObject();
				obj.Add("EventLog", GetActionTableDictionaryJson(Config.EventLog));
				obj.Add("File", GetActionTableDictionaryJson(Config.File));
				obj.Add("Syslog", GetActionTableDictionaryJson(Config.Syslog));
				UpdateConfig(obj.ToString());
			}
			catch(Exception ex){
				return ex.Message;
			}
			return null;
		}
		
		private JObject GetActionTableDictionaryJson(Dictionary<string, List<ActionTable>> rules)
		{
			JObject result = new JObject();
			List<string> keys = new List<string>(rules.Keys);
			keys.Sort();
			foreach(string key in keys) {
				result.Add(key, GetActionTableArrayJson(rules[key]));
			}
			return result;
		}
		
		private JArray GetActionTableArrayJson(List<ActionTable> tables)
		{
			JArray result = new JArray();
			foreach(ActionTable table in tables){
				result.Add(GetActionTableJson(table));
			}
			return result;
		}
		
		private JObject GetActionTableJson(ActionTable table)
		{
			JObject result = new JObject();
			if(!Util.IsNullOrEmpty(table.LogLevel)){
				result.Add("logLevel", table.LogLevel);
			}
			if(!Util.IsNullOrEmpty(table.EventSource)){
				result.Add("source", table.EventSource);
			}
			if(!Util.IsNullOrEmpty(table.EventId)){
				result.Add("eventId", table.EventId);
			}
			result.Add("match", table.MatchPattern);
			result.Add("ignore", table.IgnorePattern);
			if(!Util.IsNullOrEmpty(table.HostName)){
				result.Add("hostname", table.HostName);
			}
			result.Add("actions", GetActionArrayJson(table.Actions));
			return result;
		}
		
		private JArray GetActionArrayJson(IEnumerable<BaseAction> actions)
		{
			JArray result = new JArray();
			foreach(BaseAction action in actions) {
				result.Add(GetActionJson(action));
			}
			return result;
		}
		
		private JObject GetActionJson(BaseAction action)
		{
			JObject result = new JObject();
			result.Add("type", action.GetName());
			Dictionary<string, object> properties = action.GetProperties();
			foreach(string name in properties.Keys){
				result.Add(name, properties[name].ToString());
			}
			return result;
		}
		
		private void UpdateConfig(string json)
		{
			string tmpName = Config.FilePath + ".tmp";
			using(StreamWriter sw = new StreamWriter(new FileStream(tmpName, FileMode.Create, FileAccess.Write, FileShare.None))){
				sw.Write(json);
			}
			File.Delete(Config.FilePath);
			File.Move(tmpName, Config.FilePath);
		}
		
		public override bool Validate()
		{
			if(Config == null) return false;
			return true;
		}
	}
}
