﻿/*
 * Created by SharpDevelop.
 * User: banana
 * Date: 2013/10/08
 * Time: 15:43
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Net;
using System.Net.Sockets;
using System.Text;
using EWatch.Models;
using EWatch.Utils;

namespace EWatch.Actions
{
	/// <summary>
	/// syslogサーバーにログを通知するアクションです。
	/// </summary>
	public class ActionSyslog : BaseAction
	{
		public const string Name = "syslog";
		
		public string RemoteHost { get; set; }

		public ActionSyslog()
		{
		}
		
		public override bool Validate()
		{
			if(Util.IsNullOrEmpty(RemoteHost)){
				log.Error("RemoteHost is not specified.");
				return false;
			}
			return true;
		}
		
		public override void Execute(LogData data)
		{
			string message = string.Format("<{0}>{1} {2} {3}",
			                               GetPriorityNumber(data.Level),
			                               GetTimestampString(data.TimeStamp),
			                               data.HostName,
			                               data.Message);
			log.DebugFormat("send message=[{0}]", message);
			byte[] sendData = Encoding.UTF8.GetBytes(message);
			UdpClient client = new UdpClient();
			IPAddress[] addr = Dns.GetHostAddresses(RemoteHost);
			if(addr.Length > 0){
				foreach(IPAddress a in addr){
					if(a.AddressFamily == AddressFamily.InterNetwork){
						client.Send(sendData, sendData.Length, new IPEndPoint(a, 514));
						return;
					}
				}
			}
			throw new Exception("Invalid remote address");
		}
		
		private int GetPriorityNumber(string level)
		{
			int facility = 0;
			if(!Util.IsNullOrEmpty(level)){
				switch(level[0]){
					case 'E':
						facility = 3;
						break;
					case 'W':
						facility = 4;
						break;
					case 'I':
						facility = 6;
						break;
				}
			}
			return facility*8+1;
		}
		
		private string GetTimestampString(DateTime? timestamp)
		{
			if(timestamp != null){
				return string.Format("{0} {1} {2}",
				                     Util.GetMonthString(timestamp.Value.Month),
				                     timestamp.Value.Day.ToString("##"),
				                     timestamp.Value.ToString("HH:mm:ss"));
			}
			return null;
		}
	}
}
