﻿/*
 * Created by SharpDevelop.
 * User: banana
 * Date: 2013/10/04
 * Time: 12:04
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Collections.Generic;
using System.IO;
using System.Reflection;
using EWatch.Models.Configurations;
using EWatch.Utils;
using EWatch.Actions;
using log4net;

namespace EWatch
{
	/// <summary>
	/// Description of Configuration.
	/// </summary>
	public class Configuration
	{
		protected ILog log = LogManager.GetLogger(System.Reflection.MethodBase.GetCurrentMethod().DeclaringType);

		private Dictionary<string,List<ActionTable>> _eventLogs;
		private Dictionary<string,List<ActionTable>> _files;
		private Dictionary<string,List<ActionTable>> _syslogs;
		private string _path;		
		private Dictionary<string,Type> _actionTypeDic;
		
		public Dictionary<string,List<ActionTable>> EventLog {
			get { return _eventLogs; }
		}
		public Dictionary<string,List<ActionTable>> File {
			get { return _files; }
		}
		public Dictionary<string,List<ActionTable>> Syslog {
			get { return _syslogs; }
		}
		public string FilePath {
			get { return _path; }
		}
		private string FileName {
			set {
				_path = Path.Combine(
					Path.Combine(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location), "etc"),
					value);
			}
		}
		
		public Configuration() : this(true)
		{
		}
		
		public Configuration(bool load) : this(load, null)
		{
		}
		
		public Configuration(bool load, string filename)
		{
			FileName = filename ?? "EWatch.config.json";
			if(load){
				Type[] actionTypes = Util.ListTypeInNameSpace(Assembly.GetExecutingAssembly(), "EWatch.Actions");
				Load(actionTypes);
			}
			else{
				_eventLogs = new Dictionary<string, List<ActionTable>>();
				_files = new Dictionary<string, List<ActionTable>>();
				_syslogs = new Dictionary<string, List<ActionTable>>();
			}
		}
		
		public static Configuration EmptyConfiguration()
		{
			return new Configuration(false);
		}
		
		public void Load(Type[] actionTypes)
		{
			_actionTypeDic = GetActionDictionary(actionTypes);
			_eventLogs = new Dictionary<string, List<ActionTable>>();
			_files = new Dictionary<string, List<ActionTable>>();
			_syslogs = new Dictionary<string, List<ActionTable>>();
			ParseJson(ReadJson());
		}
		
		private string ReadJson()
		{
			string result = null;
			using(StreamReader sr = new StreamReader(new FileStream(_path, FileMode.Open, FileAccess.Read, FileShare.ReadWrite)))
			{
				result = sr.ReadToEnd();
			}
			return result;
		}
		
		private void ParseJson(string json)
		{
			object j = JsonUtil.Parse(json);
			object je = JsonUtil.GetObject(j, "EventLog");
			if(je != null){
				foreach(string propertyName in JsonUtil.GetPropertyNames(je)){
					object je_ = JsonUtil.GetObject(je, propertyName);
					_eventLogs.Add(propertyName, GetActionTable(je_));
				}
			}
			object jf = JsonUtil.GetObject(j, "File");
			if(jf != null){
				foreach(string propertyName in JsonUtil.GetPropertyNames(jf)){
					object jf_ = JsonUtil.GetObject(jf, propertyName);
					_files.Add(propertyName, GetActionTable(jf_));
				}
			}
			object js = JsonUtil.GetObject(j, "Syslog");
			if(js != null){
				foreach(string propertyName in JsonUtil.GetPropertyNames(js)){
					object js_ = JsonUtil.GetObject(js, propertyName);
					_syslogs.Add(propertyName, GetActionTable(js_));
				}
			}
			

		}
		
		private List<ActionTable> GetActionTable(object j)
		{
			List<ActionTable> result = new List<ActionTable>();
			for(int index=0; index<JsonUtil.GetCount(j); index++){
				object jo = JsonUtil.GetObject(j, index);
				if(!JsonUtil.IsComment(jo)){
					ActionTable action = new ActionTable {
						LogLevel = JsonUtil.GetString(jo, "logLevel"),
						EventSource = JsonUtil.GetString(jo, "source"),
						EventId = Util.StringToInt(JsonUtil.GetString(jo, "eventId")),
						HostName = JsonUtil.GetString(jo, "hostname"),
						MatchPattern = JsonUtil.GetString(jo, "match"),
						IgnorePattern = JsonUtil.GetString(jo, "ignore"),
					};
					action.Actions = GetActions(JsonUtil.GetArray(jo, "actions"));
					result.Add(action);
				}
			}
			return result;
		}
		
		private List<BaseAction> GetActions(object j)
		{
			List<BaseAction> result = new List<BaseAction>();
			if(j != null){
				for(int index=0; index<JsonUtil.GetCount(j); index++){
					BaseAction action = null;
					object jo = JsonUtil.GetObject(j, index);
					string type = JsonUtil.GetString(jo, "type");
					if(_actionTypeDic.ContainsKey(type)){
						action = (BaseAction)Activator.CreateInstance(_actionTypeDic[type]);
						PropertyInfo[] props = action.GetType().GetProperties();
						foreach(PropertyInfo p in props){
							object value = JsonUtil.GetObject(jo, p.Name);
							if(value != null){
								p.SetValue(action, value.ToString(), null);
							}
						}
					}
					if(action != null){
						if(action.Validate()){
							result.Add(action);
						}
						else{
							log.WarnFormat("Validation failed : type={0}, {1}", type, action.ToString());
						}
					}
					else{
						log.WarnFormat("Invalid action type : {0}", type);
					}
				}
			}
			return result;
		}
		
		private Dictionary<string, Type> GetActionDictionary(Type[] actionTypes)
		{
			Dictionary<string, Type> result = new Dictionary<string, Type>();
			if(!Util.IsNullOrEmpty(actionTypes)){
				foreach(Type t in actionTypes){
					try {
						FieldInfo f = t.GetField("Name");
						string name = (string)f.GetValue(null);
						if(!Util.IsNullOrEmpty(name)){
							result.Add(name, t);
						}
					}
					catch(Exception) {
					}
				}
			}
			return result;
		}
		
	}
}
