﻿/*
 * Created by SharpDevelop.
 * User: banana
 * Date: 2013/10/04
 * Time: 11:32
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.IO;
using System.Reflection;
using System.ServiceProcess;
using System.Threading;
using EWatch.Actions;
using EWatch.Utils;
using EWatch.Watchers;
using log4net;
using log4net.Config;

namespace EWatch
{
	/// <summary>
	/// Description of EWService.
	/// </summary>
	public class EWService : ServiceBase
	{
		protected ILog log;

		private Configuration config;
		private WatchThread watcher;
		private Thread worker;
		
		public string ConfigFile { get; set; }
		
		public EWService()
		{
			Directory.SetCurrentDirectory(AppDomain.CurrentDomain.BaseDirectory);
			XmlConfigurator.Configure(new FileInfo("Log4net.Config.xml"));
			log= LogManager.GetLogger(System.Reflection.MethodBase.GetCurrentMethod().DeclaringType);
		}
		
		protected override void OnStart(string[] args)
		{
			try {
				Initialize();
				StartWatch();
			}
			catch(Exception ex) {
				log.ErrorFormat("Service start error : {0}", ex.Message);
			}
		}
		
		protected override void OnStop()
		{
			StopWatch();
		}
		
		protected override void OnShutdown()
		{
			StopWatch();
		}
		
		protected override void OnPause()
		{
			if(watcher != null){
				watcher.Suspend();
			}
		}
		
		protected override void OnContinue()
		{
			if(watcher != null){
				watcher.Resume();
			}
		}
		
		public void Initialize()
		{
			config = new Configuration(true, ConfigFile);
		}
		
		public void StartWatch()
		{
			if(config != null){
				watcher = new WatchThread(config);
				worker = new Thread(new ThreadStart(watcher.Start));
				worker.Start();
				log.Info("Started");
			}
		}
		
		public void StopWatch()
		{
			if(watcher != null){
				watcher.Stop();
				worker.Join();
				log.Info("Stopped");
			}
		}
		
	}
}
