﻿/*
 * Created by SharpDevelop.
 * User: banana
 * Date: 2013/10/18
 * Time: 10:58
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using EWatch.Models;
using log4net;

namespace EWatch.Utils
{
	/// <summary>
	/// Description of ActionLogger.
	/// </summary>
	public class ActionLogger
	{
		private static ILog GetLogger()
		{
			return LogManager.GetLogger(System.Reflection.MethodBase.GetCurrentMethod().DeclaringType);
		}
		public static void Info(string actionName, LogData data)
		{
			GetLogger().InfoFormat("action:{0} success log={1}",
			                       actionName, data.ToString());
		}
		
		public static void Error(string actionName, string errorMessage, LogData data)
		{
			GetLogger().ErrorFormat("action:{0} {1} log={2}",
			                        actionName, errorMessage, data.ToString());
		}
	}
}
