﻿/*
 * Created by SharpDevelop.
 * User: banana
 * Date: 2013/10/08
 * Time: 11:00
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Collections.Generic;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading;
using EWatch.Models;
using EWatch.Models.Configurations;
using EWatch.Utils;

namespace EWatch.Watchers
{
	/// <summary>
	/// Description of SyslogServer.
	/// </summary>
	public class SyslogServer : BaseWatcher
	{
		private bool stopRunning;
		private Thread listener;
		private int listenPort;
		
		public SyslogServer(string port, List<ActionTable> actionTable) : base(actionTable)
		{
			if(!int.TryParse(port, out listenPort)){
				listenPort = 514;
			}
			stopRunning = false;
			listener = new Thread(new ThreadStart(ListenThread));
			listener.Start();
		}
		
		public override void Watch()
		{
		}
		
		public override void Dispose()
		{
			stopRunning = true;
			listener.Join();
		}
		
		private void ListenThread()
		{
			try {
				IPEndPoint endPoint = new IPEndPoint(IPAddress.Any, 0);
				UdpClient udpListener = new UdpClient(listenPort);
				byte[] receiveData;
				
				while(!stopRunning){
					try {
						udpListener.Client.ReceiveTimeout = 1000;
						receiveData = udpListener.Receive(ref endPoint);
						string data = Encoding.UTF8.GetString(receiveData);
						HandleLog(data);
					}
					catch(SocketException) {
						continue;
					}
					catch(Exception ex) {
						log.ErrorFormat("Receive error : {0}", ex.Message);
					}
				}
			}
			catch(Exception ex) {
				log.ErrorFormat("abort : {0}", ex.Message);
			}
		}
		
		private void HandleLog(string data)
		{
			data = data.Replace("\r", "").Replace("\n", "");
			Match match = Regex.Match(data, "<([0-9]+)>([A-Za-z]{3} [ 0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}) ([^ ]+) (.*)");
			if(match != null && match.Groups.Count==5){
				int priority;
				int.TryParse(match.Groups[1].Value, out priority);
				FindAndExecute(new LogData{
				               	TimeStamp = GetTimeStamp(match.Groups[2].Value),
				               	HostName = match.Groups[3].Value,
				               	Message = match.Groups[4].Value,
				               	Level = GetLevel(priority % 8),
				               	Source = GetFacilityName(priority / 8),
				               });
			}
			else{
				log.ErrorFormat("Invalid log received : {0}", data);
			}
		}
		
		private DateTime GetTimeStamp(string dateString)
		{
			DateTime result = DateTime.Now;
			Match match = Regex.Match(dateString, "([A-Za-z]{3}) ([ 0-9]{2}) ([0-9]{2}:[0-9]{2}:[0-9]{2})");
			if(match != null && match.Groups.Count==4){
				int month, day;
				month = Util.GetMonthFromString(match.Groups[1].Value);
				if(month == 0) month = DateTime.Now.Month;
				int.TryParse(match.Groups[2].Value, out day);
				result = DateTime.Parse(match.Groups[3].Value);
				result = new DateTime(result.Year, month, day, result.Hour, result.Minute, result.Second);
				if(result.Month==12 && DateTime.Now.Month==1){
					result.AddYears(-1);
				}
			}
			return result;
		}
		
		private string GetLevel(int severity)
		{
			string result = null;
			switch(severity){
			case 0:	/* EMERGENCY */
			case 1:	/* ALERT */
			case 2:	/* CRITICAL */
			case 3:	/* ERROR */
				result = "E";
				break;
			case 4:	/* WARNING */
				result = "W";
				break;
			case 5:	/* NOTICE */
			case 6:	/* INFORMATION */
				result = "I";
				break;
			case 7:	/* DEBUG */
				result = "D";
				break;
			}
			return result;
		}
		
		private string GetFacilityName(int facility)
		{
			string[] names = {
				"kernel",
				"user",
				"mail",
				"system",
				"security",
				"syslogd",
				"line printer",
				"net news",
				"uucp",
				"clock",
				"security",
				"FTP",
				"NTP",
				"audit",
				"alert",
				"clock",
				"local0",
				"local1",
				"local2",
				"local3",
				"local4",
				"local5",
				"local6",
				"local7",
			};
			if(facility >= 0 && facility < names.Length){
				return names[facility];
			}
			return null;
		}
	}
}
