@echo off

setlocal ENABLEDELAYEDEXPANSION

set category=%1

set build=Release
set bindir=..\EWatch\bin\%build%
set actionLog=%bindir%\log\action.log

set fail=0
set pass=0
set total=0

for /F %%i in ('dir /b /a:d') do (
	set subdir=%%i
	set skip=0
	if not "%category%" == "" (
		if not "%category%" == "!subdir!" set skip=1
	)
	if !skip! == 0 (
		if exist !subdir!\*.json (
			echo == !subdir! ==
			del %actionLog%
			call :StartService
			call :RunTest
			call :StopService
		)
	)
)

echo total=%total% pass=%pass% fail=%fail%
exit /b 0


:StartService
copy %subdir%\EWatch.test.json %bindir%\etc\EWatch.test.json >nul
start %bindir%\EWatch.exe -c EWatch.test.json
ping -n 4 localhost >nul
exit /b 0

:StopService
taskkill /F /im EWatch.exe >nul
ping -n 4 localhost >nul
exit /b 0

:RunTest
for /F %%i in ('dir /b %subdir%\*.cmd') do (
	set script=%%i
	set cmd=findstr "description" %subdir%\!script!
	for /F "delims=: tokens=2" %%j in ('!cmd!') do set desc=%%j
	echo   * !script! !desc!
	call %subdir%\!script!
	if !errorlevel! == 0 (
		echo     =^> PASS
		set /a pass=!pass!+1
	) else (
		echo     =^> FAIL
		set /a fail=!fail!+1
	)
	set /a total=!total!+1
)
exit /b 0
