/*
 * Decompiled with CFR 0.152.
 */
package org.artofsolving.jodconverter;

import com.sun.star.lang.XComponent;
import com.sun.star.lang.XServiceInfo;
import org.artofsolving.jodconverter.document.DocumentFamily;
import org.artofsolving.jodconverter.office.OfficeException;
import org.artofsolving.jodconverter.office.OfficeUtils;

class OfficeDocumentUtils {
    private OfficeDocumentUtils() {
        throw new AssertionError((Object)"utility class must not be instantiated");
    }

    public static DocumentFamily getDocumentFamily(XComponent document) throws OfficeException {
        XServiceInfo serviceInfo = OfficeUtils.cast(XServiceInfo.class, document);
        if (serviceInfo.supportsService("com.sun.star.text.GenericTextDocument")) {
            return DocumentFamily.TEXT;
        }
        if (serviceInfo.supportsService("com.sun.star.sheet.SpreadsheetDocument")) {
            return DocumentFamily.SPREADSHEET;
        }
        if (serviceInfo.supportsService("com.sun.star.presentation.PresentationDocument")) {
            return DocumentFamily.PRESENTATION;
        }
        if (serviceInfo.supportsService("com.sun.star.drawing.DrawingDocument")) {
            return DocumentFamily.DRAWING;
        }
        throw new OfficeException("document of unknown family: " + serviceInfo.getImplementationName());
    }
}

