/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.CellRecord;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.ss.usermodel.ErrorConstants;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;

public final class BoolErrRecord
extends CellRecord {
    public static final short sid = 517;
    private byte field_4_bBoolErr;
    private byte field_5_fError;

    public BoolErrRecord() {
    }

    public BoolErrRecord(RecordInputStream in) {
        super(in);
        this.field_4_bBoolErr = in.readByte();
        this.field_5_fError = in.readByte();
    }

    public void setValue(boolean value) {
        this.field_4_bBoolErr = value ? (byte)1 : 0;
        this.field_5_fError = 0;
    }

    public void setValue(byte value) {
        switch (value) {
            case 0: 
            case 7: 
            case 15: 
            case 23: 
            case 29: 
            case 36: 
            case 42: {
                this.field_4_bBoolErr = value;
                this.field_5_fError = 1;
                return;
            }
        }
        throw new IllegalArgumentException("Error Value can only be 0,7,15,23,29,36 or 42. It cannot be " + value);
    }

    public boolean getBooleanValue() {
        return this.field_4_bBoolErr != 0;
    }

    public byte getErrorValue() {
        return this.field_4_bBoolErr;
    }

    public boolean isBoolean() {
        return this.field_5_fError == 0;
    }

    public void setError(boolean val) {
        this.field_5_fError = (byte)(val ? 1 : 0);
    }

    public boolean isError() {
        return this.field_5_fError != 0;
    }

    protected String getRecordName() {
        return "BOOLERR";
    }

    protected void appendValueText(StringBuilder sb) {
        if (this.isBoolean()) {
            sb.append("  .boolVal = ");
            sb.append(this.getBooleanValue());
        } else {
            sb.append("  .errCode = ");
            sb.append(ErrorConstants.getText(this.getErrorValue()));
            sb.append(" (").append(HexDump.byteToHex(this.getErrorValue())).append(")");
        }
    }

    protected void serializeValue(LittleEndianOutput out) {
        out.writeByte(this.field_4_bBoolErr);
        out.writeByte(this.field_5_fError);
    }

    protected int getValueDataSize() {
        return 2;
    }

    public short getSid() {
        return 517;
    }

    public Object clone() {
        BoolErrRecord rec = new BoolErrRecord();
        this.copyBaseFields(rec);
        rec.field_4_bBoolErr = this.field_4_bBoolErr;
        rec.field_5_fError = this.field_5_fError;
        return rec;
    }
}

