/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.util;

import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;

public class Region
implements Comparable {
    private int rowFrom;
    private short colFrom;
    private int rowTo;
    private short colTo;

    public Region() {
    }

    public Region(int rowFrom, short colFrom, int rowTo, short colTo) {
        this.rowFrom = rowFrom;
        this.rowTo = rowTo;
        this.colFrom = colFrom;
        this.colTo = colTo;
    }

    public Region(String ref) {
        CellReference cellReferenceFrom = new CellReference(ref.substring(0, ref.indexOf(":")));
        CellReference cellReferenceTo = new CellReference(ref.substring(ref.indexOf(":") + 1));
        this.rowFrom = cellReferenceFrom.getRow();
        this.colFrom = cellReferenceFrom.getCol();
        this.rowTo = cellReferenceTo.getRow();
        this.colTo = cellReferenceTo.getCol();
    }

    public short getColumnFrom() {
        return this.colFrom;
    }

    public int getRowFrom() {
        return this.rowFrom;
    }

    public short getColumnTo() {
        return this.colTo;
    }

    public int getRowTo() {
        return this.rowTo;
    }

    public void setColumnFrom(short colFrom) {
        this.colFrom = colFrom;
    }

    public void setRowFrom(int rowFrom) {
        this.rowFrom = rowFrom;
    }

    public void setColumnTo(short colTo) {
        this.colTo = colTo;
    }

    public void setRowTo(int rowTo) {
        this.rowTo = rowTo;
    }

    public boolean contains(int row, short col) {
        return this.rowFrom <= row && this.rowTo >= row && this.colFrom <= col && this.colTo >= col;
    }

    public boolean equals(Region r) {
        return this.compareTo(r) == 0;
    }

    public int compareTo(Region r) {
        if (this.getRowFrom() == r.getRowFrom() && this.getColumnFrom() == r.getColumnFrom() && this.getRowTo() == r.getRowTo() && this.getColumnTo() == r.getColumnTo()) {
            return 0;
        }
        if (this.getRowFrom() < r.getRowFrom() || this.getColumnFrom() < r.getColumnFrom() || this.getRowTo() < r.getRowTo() || this.getColumnTo() < r.getColumnTo()) {
            return 1;
        }
        return -1;
    }

    public int compareTo(Object o) {
        return this.compareTo((Region)o);
    }

    public int getArea() {
        return (this.rowTo - this.rowFrom + 1) * (this.colTo - this.colFrom + 1);
    }

    public static Region[] convertCellRangesToRegions(CellRangeAddress[] cellRanges) {
        int size = cellRanges.length;
        if (size < 1) {
            return new Region[0];
        }
        Region[] result = new Region[size];
        for (int i = 0; i != size; ++i) {
            result[i] = Region.convertToRegion(cellRanges[i]);
        }
        return result;
    }

    private static Region convertToRegion(CellRangeAddress cr) {
        return new Region(cr.getFirstRow(), (short)cr.getFirstColumn(), cr.getLastRow(), (short)cr.getLastColumn());
    }

    public static CellRangeAddress[] convertRegionsToCellRanges(Region[] regions) {
        int size = regions.length;
        if (size < 1) {
            return new CellRangeAddress[0];
        }
        CellRangeAddress[] result = new CellRangeAddress[size];
        for (int i = 0; i != size; ++i) {
            result[i] = Region.convertToCellRangeAddress(regions[i]);
        }
        return result;
    }

    public static CellRangeAddress convertToCellRangeAddress(Region r) {
        return new CellRangeAddress(r.getRowFrom(), r.getRowTo(), r.getColumnFrom(), r.getColumnTo());
    }

    public String getRegionRef() {
        CellReference cellRefFrom = new CellReference(this.rowFrom, this.colFrom);
        CellReference cellRefTo = new CellReference(this.rowTo, this.colTo);
        String ref = cellRefFrom.formatAsString() + ":" + cellRefTo.formatAsString();
        return ref;
    }
}

